<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommunicationType StructType
 * Meta information extracted from the WSDL
 * - documentation: includes | Type of communication.
 * @subpackage Structs
 */
class CommunicationType extends AbstractStructBase
{
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - documentation: Phone number.
     * - base: xs:string
     * - maxLength: 35
     * - minOccurs: 0
     * @var string
     */
    public $phone;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - documentation: Emailaddress.
     * - base: xs:string
     * - maxLength: 70
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The contactPerson
     * Meta information extracted from the WSDL
     * - documentation: First name and last name of contact person.
     * - base: xs:string
     * - maxLength: 35
     * - minOccurs: 0
     * @var string
     */
    public $contactPerson;
    /**
     * Constructor method for CommunicationType
     * @uses CommunicationType::setPhone()
     * @uses CommunicationType::setEmail()
     * @uses CommunicationType::setContactPerson()
     * @param string $phone
     * @param string $email
     * @param string $contactPerson
     */
    public function __construct($phone = null, $email = null, $contactPerson = null)
    {
        $this
            ->setPhone($phone)
            ->setEmail($email)
            ->setContactPerson($contactPerson);
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \StructType\CommunicationType
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($phone) && mb_strlen($phone) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\CommunicationType
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        // validation for constraint: maxLength(70)
        if (!is_null($email) && mb_strlen($email) > 70) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 70', mb_strlen($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get contactPerson value
     * @return string|null
     */
    public function getContactPerson()
    {
        return $this->contactPerson;
    }
    /**
     * Set contactPerson value
     * @param string $contactPerson
     * @return \StructType\CommunicationType
     */
    public function setContactPerson($contactPerson = null)
    {
        // validation for constraint: string
        if (!is_null($contactPerson) && !is_string($contactPerson)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactPerson, true), gettype($contactPerson)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($contactPerson) && mb_strlen($contactPerson) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($contactPerson)), __LINE__);
        }
        $this->contactPerson = $contactPerson;
        return $this;
    }
}
