<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelPickupRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: The version of the webservice implementation for which the requesting client is developed. | The data for cancelling a pickup order.
 * @subpackage Structs
 */
class CancelPickupRequest extends AbstractStructBase
{
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - ref: bcs:Version
     * @var \StructType\Version
     */
    public $Version;
    /**
     * The BookingConfirmationNumber
     * Meta information extracted from the WSDL
     * - documentation: The confirmation number of the pickup order which should be cancelled. Use value from pickup response attribute 'ConfirmationNumber' to cancel respective pickup order. Note: only one pickup can be deleted at a time.
     * @var string
     */
    public $BookingConfirmationNumber;
    /**
     * Constructor method for CancelPickupRequest
     * @uses CancelPickupRequest::setVersion()
     * @uses CancelPickupRequest::setBookingConfirmationNumber()
     * @param \StructType\Version $version
     * @param string $bookingConfirmationNumber
     */
    public function __construct(\StructType\Version $version = null, $bookingConfirmationNumber = null)
    {
        $this
            ->setVersion($version)
            ->setBookingConfirmationNumber($bookingConfirmationNumber);
    }
    /**
     * Get Version value
     * @return \StructType\Version|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param \StructType\Version $version
     * @return \StructType\CancelPickupRequest
     */
    public function setVersion(\StructType\Version $version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get BookingConfirmationNumber value
     * @return string|null
     */
    public function getBookingConfirmationNumber()
    {
        return $this->BookingConfirmationNumber;
    }
    /**
     * Set BookingConfirmationNumber value
     * @param string $bookingConfirmationNumber
     * @return \StructType\CancelPickupRequest
     */
    public function setBookingConfirmationNumber($bookingConfirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($bookingConfirmationNumber) && !is_string($bookingConfirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingConfirmationNumber, true), gettype($bookingConfirmationNumber)), __LINE__);
        }
        $this->BookingConfirmationNumber = $bookingConfirmationNumber;
        return $this;
    }
}
