<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookPickupResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: The version of the webservice implementation. | The data for a pickup order.
 * @subpackage Structs
 */
class BookPickupResponse extends AbstractStructBase
{
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - ref: bcs:Version
     * @var \StructType\Version
     */
    public $Version;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Success status after processing the request.
     * @var \StructType\Statusinformation
     */
    public $Status;
    /**
     * The ConfirmationNumber
     * Meta information extracted from the WSDL
     * - documentation: The confirmation number of the successfully created pickup order. It can later be used for cancelling a pickup order. Confirmation number is not available for each pickup type.
     * - minOccurs: 0
     * @var string
     */
    public $ConfirmationNumber;
    /**
     * The ShipmentNumber
     * Meta information extracted from the WSDL
     * - documentation: If available, a shipment number is returned.
     * - minOccurs: 0
     * @var string
     */
    public $ShipmentNumber;
    /**
     * Constructor method for BookPickupResponse
     * @uses BookPickupResponse::setVersion()
     * @uses BookPickupResponse::setStatus()
     * @uses BookPickupResponse::setConfirmationNumber()
     * @uses BookPickupResponse::setShipmentNumber()
     * @param \StructType\Version $version
     * @param \StructType\Statusinformation $status
     * @param string $confirmationNumber
     * @param string $shipmentNumber
     */
    public function __construct(\StructType\Version $version = null, \StructType\Statusinformation $status = null, $confirmationNumber = null, $shipmentNumber = null)
    {
        $this
            ->setVersion($version)
            ->setStatus($status)
            ->setConfirmationNumber($confirmationNumber)
            ->setShipmentNumber($shipmentNumber);
    }
    /**
     * Get Version value
     * @return \StructType\Version|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param \StructType\Version $version
     * @return \StructType\BookPickupResponse
     */
    public function setVersion(\StructType\Version $version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Status value
     * @return \StructType\Statusinformation|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\Statusinformation $status
     * @return \StructType\BookPickupResponse
     */
    public function setStatus(\StructType\Statusinformation $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ConfirmationNumber value
     * @return string|null
     */
    public function getConfirmationNumber()
    {
        return $this->ConfirmationNumber;
    }
    /**
     * Set ConfirmationNumber value
     * @param string $confirmationNumber
     * @return \StructType\BookPickupResponse
     */
    public function setConfirmationNumber($confirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNumber) && !is_string($confirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationNumber, true), gettype($confirmationNumber)), __LINE__);
        }
        $this->ConfirmationNumber = $confirmationNumber;
        return $this;
    }
    /**
     * Get ShipmentNumber value
     * @return string|null
     */
    public function getShipmentNumber()
    {
        return $this->ShipmentNumber;
    }
    /**
     * Set ShipmentNumber value
     * @param string $shipmentNumber
     * @return \StructType\BookPickupResponse
     */
    public function setShipmentNumber($shipmentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentNumber) && !is_string($shipmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentNumber, true), gettype($shipmentNumber)), __LINE__);
        }
        $this->ShipmentNumber = $shipmentNumber;
        return $this;
    }
}
