<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for exportDocResponseType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Dial to determine label ouput format. Must be either 'URL' or 'B64' = Base64encoded: it is possible to request an URL for receiving the label as PDF stream, or to request the label as base64encoded binary data directly. If not
 * defined by client, web service defaults to 'URL'.
 * @subpackage Enumerations
 */
class ExportDocResponseType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'URL'
     * @return string 'URL'
     */
    const VALUE_URL = 'URL';
    /**
     * Constant for value 'B64'
     * @return string 'B64'
     */
    const VALUE_B_64 = 'B64';
    /**
     * Constant for value 'ZPL2'
     * @return string 'ZPL2'
     */
    const VALUE_ZPL_2 = 'ZPL2';
    /**
     * Return allowed values
     * @uses self::VALUE_URL
     * @uses self::VALUE_B_64
     * @uses self::VALUE_ZPL_2
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_URL,
            self::VALUE_B_64,
            self::VALUE_ZPL_2,
        );
    }
}
