<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Status StructType
 * Meta information extracted from the WSDL
 * - documentation: includes | part of webservice response
 * @subpackage Structs
 */
class Status extends AbstractStructBase
{
    /**
     * The statuscode
     * Meta information extracted from the WSDL
     * - documentation: statuscode value.
     * - base: xs:string
     * - maxLength: 10
     * @var string
     */
    public $statuscode;
    /**
     * The statusDescription
     * Meta information extracted from the WSDL
     * - documentation: description corresponding to the statuscode
     * - base: xs:string
     * - maxLength: 500
     * @var string
     */
    public $statusDescription;
    /**
     * Constructor method for Status
     * @uses Status::setStatuscode()
     * @uses Status::setStatusDescription()
     * @param string $statuscode
     * @param string $statusDescription
     */
    public function __construct($statuscode = null, $statusDescription = null)
    {
        $this
            ->setStatuscode($statuscode)
            ->setStatusDescription($statusDescription);
    }
    /**
     * Get statuscode value
     * @return string|null
     */
    public function getStatuscode()
    {
        return $this->statuscode;
    }
    /**
     * Set statuscode value
     * @param string $statuscode
     * @return \StructType\Status
     */
    public function setStatuscode($statuscode = null)
    {
        // validation for constraint: string
        if (!is_null($statuscode) && !is_string($statuscode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statuscode, true), gettype($statuscode)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($statuscode) && mb_strlen($statuscode) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($statuscode)), __LINE__);
        }
        $this->statuscode = $statuscode;
        return $this;
    }
    /**
     * Get statusDescription value
     * @return string|null
     */
    public function getStatusDescription()
    {
        return $this->statusDescription;
    }
    /**
     * Set statusDescription value
     * @param string $statusDescription
     * @return \StructType\Status
     */
    public function setStatusDescription($statusDescription = null)
    {
        // validation for constraint: string
        if (!is_null($statusDescription) && !is_string($statusDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusDescription, true), gettype($statusDescription)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($statusDescription) && mb_strlen($statusDescription) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($statusDescription)), __LINE__);
        }
        $this->statusDescription = $statusDescription;
        return $this;
    }
}
