<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipperTypeType StructType
 * Meta information extracted from the WSDL
 * - documentation: The data of the shipper or return receiver.
 * @subpackage Structs
 */
class ShipperTypeType extends AbstractStructBase
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Name of the Return Receiver
     * @var \StructType\NameType
     */
    public $Name;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - documentation: Contains address data.
     * @var \StructType\NativeAddressTypeNew
     */
    public $Address;
    /**
     * The Communication
     * Meta information extracted from the WSDL
     * - documentation: Information about communication.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CommunicationType
     */
    public $Communication;
    /**
     * Constructor method for ShipperTypeType
     * @uses ShipperTypeType::setName()
     * @uses ShipperTypeType::setAddress()
     * @uses ShipperTypeType::setCommunication()
     * @param \StructType\NameType $name
     * @param \StructType\NativeAddressTypeNew $address
     * @param \StructType\CommunicationType $communication
     */
    public function __construct(\StructType\NameType $name = null, \StructType\NativeAddressTypeNew $address = null, \StructType\CommunicationType $communication = null)
    {
        $this
            ->setName($name)
            ->setAddress($address)
            ->setCommunication($communication);
    }
    /**
     * Get Name value
     * @return \StructType\NameType|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param \StructType\NameType $name
     * @return \StructType\ShipperTypeType
     */
    public function setName(\StructType\NameType $name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\NativeAddressTypeNew|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\NativeAddressTypeNew $address
     * @return \StructType\ShipperTypeType
     */
    public function setAddress(\StructType\NativeAddressTypeNew $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Communication value
     * @return \StructType\CommunicationType|null
     */
    public function getCommunication()
    {
        return $this->Communication;
    }
    /**
     * Set Communication value
     * @param \StructType\CommunicationType $communication
     * @return \StructType\ShipperTypeType
     */
    public function setCommunication(\StructType\CommunicationType $communication = null)
    {
        $this->Communication = $communication;
        return $this;
    }
}
