<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentItemType StructType
 * Meta information extracted from the WSDL
 * - documentation: Item/Piece data.
 * @subpackage Structs
 */
class ShipmentItemType extends AbstractStructBase
{
    /**
     * The weightInKG
     * Meta information extracted from the WSDL
     * - documentation: The weight of the piece in kg
     * - base: xs:decimal
     * - fractionDigits: 2
     * - maxInclusive: 9999999.99
     * - minInclusive: 0.0
     * @var float
     */
    public $weightInKG;
    /**
     * The lengthInCM
     * Meta information extracted from the WSDL
     * - documentation: The length of the piece in cm.
     * - base: xs:integer
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 4
     * @var int
     */
    public $lengthInCM;
    /**
     * The widthInCM
     * Meta information extracted from the WSDL
     * - documentation: The width of the piece in cm.
     * - base: xs:integer
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 4
     * @var int
     */
    public $widthInCM;
    /**
     * The heightInCM
     * Meta information extracted from the WSDL
     * - documentation: The height of the piece in cm.
     * - base: xs:integer
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 4
     * @var int
     */
    public $heightInCM;
    /**
     * Constructor method for ShipmentItemType
     * @uses ShipmentItemType::setWeightInKG()
     * @uses ShipmentItemType::setLengthInCM()
     * @uses ShipmentItemType::setWidthInCM()
     * @uses ShipmentItemType::setHeightInCM()
     * @param float $weightInKG
     * @param int $lengthInCM
     * @param int $widthInCM
     * @param int $heightInCM
     */
    public function __construct($weightInKG = null, $lengthInCM = null, $widthInCM = null, $heightInCM = null)
    {
        $this
            ->setWeightInKG($weightInKG)
            ->setLengthInCM($lengthInCM)
            ->setWidthInCM($widthInCM)
            ->setHeightInCM($heightInCM);
    }
    /**
     * Get weightInKG value
     * @return float|null
     */
    public function getWeightInKG()
    {
        return $this->weightInKG;
    }
    /**
     * Set weightInKG value
     * @param float $weightInKG
     * @return \StructType\ShipmentItemType
     */
    public function setWeightInKG($weightInKG = null)
    {
        // validation for constraint: float
        if (!is_null($weightInKG) && !(is_float($weightInKG) || is_numeric($weightInKG))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weightInKG, true), gettype($weightInKG)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($weightInKG) && mb_strlen(mb_substr($weightInKG, false !== mb_strpos($weightInKG, '.') ? mb_strpos($weightInKG, '.') + 1 : mb_strlen($weightInKG))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($weightInKG, true), mb_strlen(mb_substr($weightInKG, mb_strpos($weightInKG, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive(9999999.99)
        if (!is_null($weightInKG) && $weightInKG > 9999999.99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999.99', var_export($weightInKG, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.0)
        if (!is_null($weightInKG) && $weightInKG < 0.0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.0', var_export($weightInKG, true)), __LINE__);
        }
        $this->weightInKG = $weightInKG;
        return $this;
    }
    /**
     * Get lengthInCM value
     * @return int|null
     */
    public function getLengthInCM()
    {
        return $this->lengthInCM;
    }
    /**
     * Set lengthInCM value
     * @param int $lengthInCM
     * @return \StructType\ShipmentItemType
     */
    public function setLengthInCM($lengthInCM = null)
    {
        // validation for constraint: int
        if (!is_null($lengthInCM) && !(is_int($lengthInCM) || ctype_digit($lengthInCM))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lengthInCM, true), gettype($lengthInCM)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($lengthInCM) && $lengthInCM < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($lengthInCM, true)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($lengthInCM) && mb_strlen(preg_replace('/(\D)/', '', $lengthInCM)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($lengthInCM, true), mb_strlen(preg_replace('/(\D)/', '', $lengthInCM))), __LINE__);
        }
        $this->lengthInCM = $lengthInCM;
        return $this;
    }
    /**
     * Get widthInCM value
     * @return int|null
     */
    public function getWidthInCM()
    {
        return $this->widthInCM;
    }
    /**
     * Set widthInCM value
     * @param int $widthInCM
     * @return \StructType\ShipmentItemType
     */
    public function setWidthInCM($widthInCM = null)
    {
        // validation for constraint: int
        if (!is_null($widthInCM) && !(is_int($widthInCM) || ctype_digit($widthInCM))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($widthInCM, true), gettype($widthInCM)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($widthInCM) && $widthInCM < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($widthInCM, true)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($widthInCM) && mb_strlen(preg_replace('/(\D)/', '', $widthInCM)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($widthInCM, true), mb_strlen(preg_replace('/(\D)/', '', $widthInCM))), __LINE__);
        }
        $this->widthInCM = $widthInCM;
        return $this;
    }
    /**
     * Get heightInCM value
     * @return int|null
     */
    public function getHeightInCM()
    {
        return $this->heightInCM;
    }
    /**
     * Set heightInCM value
     * @param int $heightInCM
     * @return \StructType\ShipmentItemType
     */
    public function setHeightInCM($heightInCM = null)
    {
        // validation for constraint: int
        if (!is_null($heightInCM) && !(is_int($heightInCM) || ctype_digit($heightInCM))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($heightInCM, true), gettype($heightInCM)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($heightInCM) && $heightInCM < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($heightInCM, true)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($heightInCM) && mb_strlen(preg_replace('/(\D)/', '', $heightInCM)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($heightInCM, true), mb_strlen(preg_replace('/(\D)/', '', $heightInCM))), __LINE__);
        }
        $this->heightInCM = $heightInCM;
        return $this;
    }
}
