<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentDetailsType StructType
 * Meta information extracted from the WSDL
 * - documentation: Details of a shipment.
 * @subpackage Structs
 */
class ShipmentDetailsType extends AbstractStructBase
{
    /**
     * The product
     * Meta information extracted from the WSDL
     * - documentation: Determines the DHL Paket product to be ordered. V01PAK: DHL PAKET; V53WPAK: DHL PAKET International; V54EPAK: DHL Europaket; V62WP: Warenpost; V66WPI: Warenpost International
     * @var string
     */
    public $product;
    /**
     * The accountNumber
     * Meta information extracted from the WSDL
     * - documentation: DHL account number (14 digits).
     * - base: xs:string
     * - maxLength: 14
     * - minLength: 14
     * - ref: cis:accountNumber
     * @var string
     */
    public $accountNumber;
    /**
     * The customerReference
     * Meta information extracted from the WSDL
     * - documentation: A reference number that the client can assign for better association purposes. Appears on shipment label. To use the reference number for tracking purposes, it should be at least 8 characters long and unique
     * - base: xs:string
     * - maxLength: 35
     * - minOccurs: 0
     * @var string
     */
    public $customerReference;
    /**
     * The shipmentDate
     * Meta information extracted from the WSDL
     * - documentation: Date of shipment should be close to current date and must not be in the past. Iso format required: yyyy-mm-dd.
     * - base: xs:string
     * - maxLength: 10
     * - minLength: 10
     * @var string
     */
    public $shipmentDate;
    /**
     * The costCentre
     * Meta information extracted from the WSDL
     * - documentation: Name of a cost center. Appears on shipment label.
     * - base: xs:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $costCentre;
    /**
     * The returnShipmentAccountNumber
     * Meta information extracted from the WSDL
     * - documentation: DHL account number (14 digits).
     * - base: xs:string
     * - maxLength: 14
     * - minLength: 14
     * - minOccurs: 0
     * @var string
     */
    public $returnShipmentAccountNumber;
    /**
     * The returnShipmentReference
     * Meta information extracted from the WSDL
     * - documentation: A reference number that the client can assign for better association purposes. Appears on return shipment label. To use the reference number for tracking purposes, it should be at least 8 characters long and unique.
     * - base: xs:string
     * - maxLength: 35
     * - minOccurs: 0
     * @var string
     */
    public $returnShipmentReference;
    /**
     * Constructor method for ShipmentDetailsType
     * @uses ShipmentDetailsType::setProduct()
     * @uses ShipmentDetailsType::setAccountNumber()
     * @uses ShipmentDetailsType::setCustomerReference()
     * @uses ShipmentDetailsType::setShipmentDate()
     * @uses ShipmentDetailsType::setCostCentre()
     * @uses ShipmentDetailsType::setReturnShipmentAccountNumber()
     * @uses ShipmentDetailsType::setReturnShipmentReference()
     * @param string $product
     * @param string $accountNumber
     * @param string $customerReference
     * @param string $shipmentDate
     * @param string $costCentre
     * @param string $returnShipmentAccountNumber
     * @param string $returnShipmentReference
     */
    public function __construct($product = null, $accountNumber = null, $customerReference = null, $shipmentDate = null, $costCentre = null, $returnShipmentAccountNumber = null, $returnShipmentReference = null)
    {
        $this
            ->setProduct($product)
            ->setAccountNumber($accountNumber)
            ->setCustomerReference($customerReference)
            ->setShipmentDate($shipmentDate)
            ->setCostCentre($costCentre)
            ->setReturnShipmentAccountNumber($returnShipmentAccountNumber)
            ->setReturnShipmentReference($returnShipmentReference);
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param string $product
     * @return \StructType\ShipmentDetailsType
     */
    public function setProduct($product = null)
    {
        // validation for constraint: string
        if (!is_null($product) && !is_string($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($product, true), gettype($product)), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get accountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->accountNumber;
    }
    /**
     * Set accountNumber value
     * @param string $accountNumber
     * @return \StructType\ShipmentDetailsType
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        // validation for constraint: maxLength(14)
        if (!is_null($accountNumber) && mb_strlen($accountNumber) > 14) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 14', mb_strlen($accountNumber)), __LINE__);
        }
        // validation for constraint: minLength(14)
        if (!is_null($accountNumber) && mb_strlen($accountNumber) < 14) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 14', mb_strlen($accountNumber)), __LINE__);
        }
        $this->accountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get customerReference value
     * @return string|null
     */
    public function getCustomerReference()
    {
        return $this->customerReference;
    }
    /**
     * Set customerReference value
     * @param string $customerReference
     * @return \StructType\ShipmentDetailsType
     */
    public function setCustomerReference($customerReference = null)
    {
        // validation for constraint: string
        if (!is_null($customerReference) && !is_string($customerReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerReference, true), gettype($customerReference)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($customerReference) && mb_strlen($customerReference) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($customerReference)), __LINE__);
        }
        $this->customerReference = $customerReference;
        return $this;
    }
    /**
     * Get shipmentDate value
     * @return string|null
     */
    public function getShipmentDate()
    {
        return $this->shipmentDate;
    }
    /**
     * Set shipmentDate value
     * @param string $shipmentDate
     * @return \StructType\ShipmentDetailsType
     */
    public function setShipmentDate($shipmentDate = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentDate) && !is_string($shipmentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentDate, true), gettype($shipmentDate)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($shipmentDate) && mb_strlen($shipmentDate) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($shipmentDate)), __LINE__);
        }
        // validation for constraint: minLength(10)
        if (!is_null($shipmentDate) && mb_strlen($shipmentDate) < 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 10', mb_strlen($shipmentDate)), __LINE__);
        }
        $this->shipmentDate = $shipmentDate;
        return $this;
    }
    /**
     * Get costCentre value
     * @return string|null
     */
    public function getCostCentre()
    {
        return $this->costCentre;
    }
    /**
     * Set costCentre value
     * @param string $costCentre
     * @return \StructType\ShipmentDetailsType
     */
    public function setCostCentre($costCentre = null)
    {
        // validation for constraint: string
        if (!is_null($costCentre) && !is_string($costCentre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($costCentre, true), gettype($costCentre)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($costCentre) && mb_strlen($costCentre) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($costCentre)), __LINE__);
        }
        $this->costCentre = $costCentre;
        return $this;
    }
    /**
     * Get returnShipmentAccountNumber value
     * @return string|null
     */
    public function getReturnShipmentAccountNumber()
    {
        return $this->returnShipmentAccountNumber;
    }
    /**
     * Set returnShipmentAccountNumber value
     * @param string $returnShipmentAccountNumber
     * @return \StructType\ShipmentDetailsType
     */
    public function setReturnShipmentAccountNumber($returnShipmentAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($returnShipmentAccountNumber) && !is_string($returnShipmentAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnShipmentAccountNumber, true), gettype($returnShipmentAccountNumber)), __LINE__);
        }
        // validation for constraint: maxLength(14)
        if (!is_null($returnShipmentAccountNumber) && mb_strlen($returnShipmentAccountNumber) > 14) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 14', mb_strlen($returnShipmentAccountNumber)), __LINE__);
        }
        // validation for constraint: minLength(14)
        if (!is_null($returnShipmentAccountNumber) && mb_strlen($returnShipmentAccountNumber) < 14) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 14', mb_strlen($returnShipmentAccountNumber)), __LINE__);
        }
        $this->returnShipmentAccountNumber = $returnShipmentAccountNumber;
        return $this;
    }
    /**
     * Get returnShipmentReference value
     * @return string|null
     */
    public function getReturnShipmentReference()
    {
        return $this->returnShipmentReference;
    }
    /**
     * Set returnShipmentReference value
     * @param string $returnShipmentReference
     * @return \StructType\ShipmentDetailsType
     */
    public function setReturnShipmentReference($returnShipmentReference = null)
    {
        // validation for constraint: string
        if (!is_null($returnShipmentReference) && !is_string($returnShipmentReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnShipmentReference, true), gettype($returnShipmentReference)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($returnShipmentReference) && mb_strlen($returnShipmentReference) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($returnShipmentReference)), __LINE__);
        }
        $this->returnShipmentReference = $returnShipmentReference;
        return $this;
    }
}
