<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceconfigurationUnfree StructType
 * @subpackage Structs
 */
class ServiceconfigurationUnfree extends AbstractStructBase
{
    /**
     * The active
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $active;
    /**
     * The PaymentType
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $PaymentType;
    /**
     * The CustomerNumber
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * - minLength: 0
     * - use: optional
     * @var string
     */
    public $CustomerNumber;
    /**
     * Constructor method for ServiceconfigurationUnfree
     * @uses ServiceconfigurationUnfree::setActive()
     * @uses ServiceconfigurationUnfree::setPaymentType()
     * @uses ServiceconfigurationUnfree::setCustomerNumber()
     * @param string $active
     * @param string $paymentType
     * @param string $customerNumber
     */
    public function __construct($active = null, $paymentType = null, $customerNumber = null)
    {
        $this
            ->setActive($active)
            ->setPaymentType($paymentType)
            ->setCustomerNumber($customerNumber);
    }
    /**
     * Get active value
     * @return string
     */
    public function getActive()
    {
        return $this->active;
    }
    /**
     * Set active value
     * @param string $active
     * @return \StructType\ServiceconfigurationUnfree
     */
    public function setActive($active = null)
    {
        // validation for constraint: string
        if (!is_null($active) && !is_string($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->active = $active;
        return $this;
    }
    /**
     * Get PaymentType value
     * @return string
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @param string $paymentType
     * @return \StructType\ServiceconfigurationUnfree
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentType) && !is_string($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentType, true), gettype($paymentType)), __LINE__);
        }
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Get CustomerNumber value
     * @return string|null
     */
    public function getCustomerNumber()
    {
        return $this->CustomerNumber;
    }
    /**
     * Set CustomerNumber value
     * @param string $customerNumber
     * @return \StructType\ServiceconfigurationUnfree
     */
    public function setCustomerNumber($customerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($customerNumber) && !is_string($customerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerNumber, true), gettype($customerNumber)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($customerNumber) && mb_strlen($customerNumber) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($customerNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($customerNumber) && mb_strlen($customerNumber) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($customerNumber)), __LINE__);
        }
        $this->CustomerNumber = $customerNumber;
        return $this;
    }
}
