<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PickupOrdererType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information about the pickup orderer. In the PickupOrdererType the following data fields are processed/mandatory/optional:----------------------------------------------------------------------------------------------Salutation
 * (optional) : cis:NameType->Person->salutationCompany Name 1 (mandatory): cis:NameType->Company->name1Company Name 2 (optional) : cis:NameType->Company->name2Contact Name (mandatory): cis:CommunicationType->contactPersonStreet Name (mandatory):
 * cis:NativeAddressType->streetNameStreet Number (mandatory): cis:NativeAddressType->streetNumberAdd. Address (optional) : cis:NativeAddressType->careOfNamePostcode (mandatory): cis:NativeAddressType->zipCity Name (mandatory):
 * cis:NativeAddressType->cityISO Country Code (mandatory): cis:NativeAddressType->Origin->CountryType->countryISOTypePhone Number (mandatory): cis:CommunicationType->phoneEmail Address (mandatory): cis:CommunicationType->email
 * @subpackage Structs
 */
class PickupOrdererType extends AbstractStructBase
{
    /**
     * The Company
     * Meta information extracted from the WSDL
     * - documentation: Determines whether orderer contact address is of the following type.
     * @var \StructType\NameType
     */
    public $Company;
    /**
     * The Name3
     * Meta information extracted from the WSDL
     * - documentation: Optional name appendix.
     * - minOccurs: 0
     * @var string
     */
    public $Name3;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - documentation: Data fields for orderer's address.
     * @var \StructType\NativeAddressType
     */
    public $Address;
    /**
     * The Communication
     * Meta information extracted from the WSDL
     * - documentation: Info about communication.
     * @var \StructType\CommunicationType
     */
    public $Communication;
    /**
     * Constructor method for PickupOrdererType
     * @uses PickupOrdererType::setCompany()
     * @uses PickupOrdererType::setName3()
     * @uses PickupOrdererType::setAddress()
     * @uses PickupOrdererType::setCommunication()
     * @param \StructType\NameType $company
     * @param string $name3
     * @param \StructType\NativeAddressType $address
     * @param \StructType\CommunicationType $communication
     */
    public function __construct(\StructType\NameType $company = null, $name3 = null, \StructType\NativeAddressType $address = null, \StructType\CommunicationType $communication = null)
    {
        $this
            ->setCompany($company)
            ->setName3($name3)
            ->setAddress($address)
            ->setCommunication($communication);
    }
    /**
     * Get Company value
     * @return \StructType\NameType|null
     */
    public function getCompany()
    {
        return $this->Company;
    }
    /**
     * Set Company value
     * @param \StructType\NameType $company
     * @return \StructType\PickupOrdererType
     */
    public function setCompany(\StructType\NameType $company = null)
    {
        $this->Company = $company;
        return $this;
    }
    /**
     * Get Name3 value
     * @return string|null
     */
    public function getName3()
    {
        return $this->Name3;
    }
    /**
     * Set Name3 value
     * @param string $name3
     * @return \StructType\PickupOrdererType
     */
    public function setName3($name3 = null)
    {
        // validation for constraint: string
        if (!is_null($name3) && !is_string($name3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name3, true), gettype($name3)), __LINE__);
        }
        $this->Name3 = $name3;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\NativeAddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\NativeAddressType $address
     * @return \StructType\PickupOrdererType
     */
    public function setAddress(\StructType\NativeAddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Communication value
     * @return \StructType\CommunicationType|null
     */
    public function getCommunication()
    {
        return $this->Communication;
    }
    /**
     * Set Communication value
     * @param \StructType\CommunicationType $communication
     * @return \StructType\PickupOrdererType
     */
    public function setCommunication(\StructType\CommunicationType $communication = null)
    {
        $this->Communication = $communication;
        return $this;
    }
}
