<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NameType StructType
 * Meta information extracted from the WSDL
 * - documentation: includes | Type of name
 * @subpackage Structs
 */
class NameType extends AbstractStructBase
{
    /**
     * The name1
     * Meta information extracted from the WSDL
     * - documentation: Name of receiver (first part)
     * - base: xs:string
     * - maxLength: 35
     * - minOccurs: 1
     * - ref: cis:name1
     * @var string
     */
    public $name1;
    /**
     * The name2
     * Meta information extracted from the WSDL
     * - documentation: Name of company (second part).
     * - base: xs:string
     * - maxLength: 35
     * - minOccurs: 0
     * - ref: cis:name2
     * @var string
     */
    public $name2;
    /**
     * The name3
     * Meta information extracted from the WSDL
     * - documentation: Name of company (third part).
     * - base: xs:string
     * - maxLength: 35
     * - minOccurs: 0
     * - ref: cis:name3
     * @var string
     */
    public $name3;
    /**
     * Constructor method for NameType
     * @uses NameType::setName1()
     * @uses NameType::setName2()
     * @uses NameType::setName3()
     * @param string $name1
     * @param string $name2
     * @param string $name3
     */
    public function __construct($name1 = null, $name2 = null, $name3 = null)
    {
        $this
            ->setName1($name1)
            ->setName2($name2)
            ->setName3($name3);
    }
    /**
     * Get name1 value
     * @return string
     */
    public function getName1()
    {
        return $this->name1;
    }
    /**
     * Set name1 value
     * @param string $name1
     * @return \StructType\NameType
     */
    public function setName1($name1 = null)
    {
        // validation for constraint: string
        if (!is_null($name1) && !is_string($name1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name1, true), gettype($name1)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($name1) && mb_strlen($name1) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($name1)), __LINE__);
        }
        $this->name1 = $name1;
        return $this;
    }
    /**
     * Get name2 value
     * @return string|null
     */
    public function getName2()
    {
        return $this->name2;
    }
    /**
     * Set name2 value
     * @param string $name2
     * @return \StructType\NameType
     */
    public function setName2($name2 = null)
    {
        // validation for constraint: string
        if (!is_null($name2) && !is_string($name2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name2, true), gettype($name2)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($name2) && mb_strlen($name2) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($name2)), __LINE__);
        }
        $this->name2 = $name2;
        return $this;
    }
    /**
     * Get name3 value
     * @return string|null
     */
    public function getName3()
    {
        return $this->name3;
    }
    /**
     * Set name3 value
     * @param string $name3
     * @return \StructType\NameType
     */
    public function setName3($name3 = null)
    {
        // validation for constraint: string
        if (!is_null($name3) && !is_string($name3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name3, true), gettype($name3)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($name3) && mb_strlen($name3) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($name3)), __LINE__);
        }
        $this->name3 = $name3;
        return $this;
    }
}
