<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetLabelRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: The version of the webservice implementation for which the requesting client is developed. | The identifier for the shipment for which the label url is requested.
 * @subpackage Structs
 */
class GetLabelRequest extends AbstractStructBase
{
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - ref: bcs:Version
     * @var \StructType\Version
     */
    public $Version;
    /**
     * The shipmentNumber
     * Meta information extracted from the WSDL
     * - documentation: Can contain any DHL shipmentnumber. | Can contain any DHL shipmentnumber. For successful and unsuccessful operations, the requested ShipmentNumber to be deleted is returned. This is no matter if the operation could be performed or
     * not.
     * - base: xs:string
     * - maxLength: 39
     * - maxOccurs: 30
     * - ref: cis:shipmentNumber
     * @var string[]
     */
    public $shipmentNumber;
    /**
     * The labelResponseType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $labelResponseType;
    /**
     * The groupProfileName
     * Meta information extracted from the WSDL
     * - documentation: The group profile you select defines the billing numbers you can use for creating shipments. To define group profiles please visit our business costumer portal. The group profile defines the shipments you can get documents for. The
     * shipment needs to have an account/billing number allocated to the group profile. To define group profiles please visit our business costumer portal. | The group profile you select defines the billing numbers you can use for creating shipments. To
     * define group profiles please visit our business costumer portal.
     * - base: xs:string
     * - minOccurs: 0
     * @var string
     */
    public $groupProfileName;
    /**
     * The labelFormat
     * Meta information extracted from the WSDL
     * - documentation: In this optional section you can define the following label formats: A4:common label laser printing A4 plain paper; 910-300-700: common label laser printing 105 x 205 mm (910-300-700); 910-300-700-oz: common label laser printing 105
     * x 205 mm without additional barcode labels (910-300-700); 910-300-300: common label laser printing 105 x 148 mm (910-300-700); 910-300-300-oz: common label laser printing 105 x 148 mm without additional barcode labels (910-300-300); 910-300-710:
     * common label laser printing 105 x 208 mm (910-300-710); 910-300-600: common label thermal printing 103 x 199 mm (910-300-600, 910-300-610); 910-300-400: common label thermal printing 103 x 150 mm (910-300-400, 910-300-410); 100x70mm: 100 x 70 mm
     * label (only for Warenpost and Warenpost International);
     * - base: xs:string
     * - minOccurs: 0
     * @var string
     */
    public $labelFormat;
    /**
     * The labelFormatRetoure
     * Meta information extracted from the WSDL
     * - documentation: In this optional section you can define the following label formats: A4:common label laser printing A4 plain paper; 910-300-700: common label laser printing 105 x 205 mm (910-300-700); 910-300-700-oz: common label laser printing 105
     * x 205 mm without additional barcode labels (910-300-700); 910-300-300: common label laser printing 105 x 148 mm (910-300-700); 910-300-300-oz: common label laser printing 105 x 148 mm without additional barcode labels (910-300-300); 910-300-710:
     * common label laser printing 105 x 208 mm (910-300-710); 910-300-600: common label thermal printing 103 x 199 mm (910-300-600, 910-300-610); 910-300-400: common label thermal printing 103 x 150 mm (910-300-400, 910-300-410); 100x70mm: 100 x 70 mm
     * label (only for Warenpost and Warenpost International);
     * - base: xs:string
     * - minOccurs: 0
     * @var string
     */
    public $labelFormatRetoure;
    /**
     * The combinedPrinting
     * Meta information extracted from the WSDL
     * - documentation: To get a single PDF for shipping and return label select this option.
     * - base: xs:string
     * - minOccurs: 0
     * @var string
     */
    public $combinedPrinting;
    /**
     * Constructor method for GetLabelRequest
     * @uses GetLabelRequest::setVersion()
     * @uses GetLabelRequest::setShipmentNumber()
     * @uses GetLabelRequest::setLabelResponseType()
     * @uses GetLabelRequest::setGroupProfileName()
     * @uses GetLabelRequest::setLabelFormat()
     * @uses GetLabelRequest::setLabelFormatRetoure()
     * @uses GetLabelRequest::setCombinedPrinting()
     * @param \StructType\Version $version
     * @param string[] $shipmentNumber
     * @param string $labelResponseType
     * @param string $groupProfileName
     * @param string $labelFormat
     * @param string $labelFormatRetoure
     * @param string $combinedPrinting
     */
    public function __construct(\StructType\Version $version = null, array $shipmentNumber = array(), $labelResponseType = null, $groupProfileName = null, $labelFormat = null, $labelFormatRetoure = null, $combinedPrinting = null)
    {
        $this
            ->setVersion($version)
            ->setShipmentNumber($shipmentNumber)
            ->setLabelResponseType($labelResponseType)
            ->setGroupProfileName($groupProfileName)
            ->setLabelFormat($labelFormat)
            ->setLabelFormatRetoure($labelFormatRetoure)
            ->setCombinedPrinting($combinedPrinting);
    }
    /**
     * Get Version value
     * @return \StructType\Version|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param \StructType\Version $version
     * @return \StructType\GetLabelRequest
     */
    public function setVersion(\StructType\Version $version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get shipmentNumber value
     * @return string[]|null
     */
    public function getShipmentNumber()
    {
        return $this->shipmentNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setShipmentNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentNumberForArrayConstraintsFromSetShipmentNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getLabelRequestShipmentNumberItem) {
            // validation for constraint: itemType
            if (!is_string($getLabelRequestShipmentNumberItem)) {
                $invalidValues[] = is_object($getLabelRequestShipmentNumberItem) ? get_class($getLabelRequestShipmentNumberItem) : sprintf('%s(%s)', gettype($getLabelRequestShipmentNumberItem), var_export($getLabelRequestShipmentNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The shipmentNumber property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setShipmentNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentNumber method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentNumberForMaxLengthConstraintFromSetShipmentNumber($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getLabelRequestShipmentNumberItem) {
            // validation for constraint: maxLength(39)
            if (mb_strlen($getLabelRequestShipmentNumberItem) > 39) {
                $invalidValues[] = var_export($getLabelRequestShipmentNumberItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 39', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set shipmentNumber value
     * @throws \InvalidArgumentException
     * @param string[] $shipmentNumber
     * @return \StructType\GetLabelRequest
     */
    public function setShipmentNumber(array $shipmentNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentNumberArrayErrorMessage = self::validateShipmentNumberForArrayConstraintsFromSetShipmentNumber($shipmentNumber))) {
            throw new \InvalidArgumentException($shipmentNumberArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(39)
        if ('' !== ($shipmentNumberMaxLengthErrorMessage = self::validateShipmentNumberForMaxLengthConstraintFromSetShipmentNumber($shipmentNumber))) {
            throw new \InvalidArgumentException($shipmentNumberMaxLengthErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($shipmentNumber) && count($shipmentNumber) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 30', count($shipmentNumber)), __LINE__);
        }
        $this->shipmentNumber = $shipmentNumber;
        return $this;
    }
    /**
     * Add item to shipmentNumber value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\GetLabelRequest
     */
    public function addToShipmentNumber($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The shipmentNumber property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(39)
        if (mb_strlen($item) > 39) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 39', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($this->shipmentNumber) && count($this->shipmentNumber) >= 30) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 30', count($this->shipmentNumber)), __LINE__);
        }
        $this->shipmentNumber[] = $item;
        return $this;
    }
    /**
     * Get labelResponseType value
     * @return string|null
     */
    public function getLabelResponseType()
    {
        return $this->labelResponseType;
    }
    /**
     * Set labelResponseType value
     * @uses \EnumType\LabelResponseType::valueIsValid()
     * @uses \EnumType\LabelResponseType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $labelResponseType
     * @return \StructType\GetLabelRequest
     */
    public function setLabelResponseType($labelResponseType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LabelResponseType::valueIsValid($labelResponseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\LabelResponseType', is_array($labelResponseType) ? implode(', ', $labelResponseType) : var_export($labelResponseType, true), implode(', ', \EnumType\LabelResponseType::getValidValues())), __LINE__);
        }
        $this->labelResponseType = $labelResponseType;
        return $this;
    }
    /**
     * Get groupProfileName value
     * @return string|null
     */
    public function getGroupProfileName()
    {
        return $this->groupProfileName;
    }
    /**
     * Set groupProfileName value
     * @param string $groupProfileName
     * @return \StructType\GetLabelRequest
     */
    public function setGroupProfileName($groupProfileName = null)
    {
        // validation for constraint: string
        if (!is_null($groupProfileName) && !is_string($groupProfileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupProfileName, true), gettype($groupProfileName)), __LINE__);
        }
        $this->groupProfileName = $groupProfileName;
        return $this;
    }
    /**
     * Get labelFormat value
     * @return string|null
     */
    public function getLabelFormat()
    {
        return $this->labelFormat;
    }
    /**
     * Set labelFormat value
     * @param string $labelFormat
     * @return \StructType\GetLabelRequest
     */
    public function setLabelFormat($labelFormat = null)
    {
        // validation for constraint: string
        if (!is_null($labelFormat) && !is_string($labelFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labelFormat, true), gettype($labelFormat)), __LINE__);
        }
        $this->labelFormat = $labelFormat;
        return $this;
    }
    /**
     * Get labelFormatRetoure value
     * @return string|null
     */
    public function getLabelFormatRetoure()
    {
        return $this->labelFormatRetoure;
    }
    /**
     * Set labelFormatRetoure value
     * @param string $labelFormatRetoure
     * @return \StructType\GetLabelRequest
     */
    public function setLabelFormatRetoure($labelFormatRetoure = null)
    {
        // validation for constraint: string
        if (!is_null($labelFormatRetoure) && !is_string($labelFormatRetoure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labelFormatRetoure, true), gettype($labelFormatRetoure)), __LINE__);
        }
        $this->labelFormatRetoure = $labelFormatRetoure;
        return $this;
    }
    /**
     * Get combinedPrinting value
     * @return string|null
     */
    public function getCombinedPrinting()
    {
        return $this->combinedPrinting;
    }
    /**
     * Set combinedPrinting value
     * @param string $combinedPrinting
     * @return \StructType\GetLabelRequest
     */
    public function setCombinedPrinting($combinedPrinting = null)
    {
        // validation for constraint: string
        if (!is_null($combinedPrinting) && !is_string($combinedPrinting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($combinedPrinting, true), gettype($combinedPrinting)), __LINE__);
        }
        $this->combinedPrinting = $combinedPrinting;
        return $this;
    }
}
