<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExportDocPosition StructType
 * Meta information extracted from the WSDL
 * - documentation: One or more child elements for every position to be defined within the Export Document. Each one contains description, country code of origin, amount, net weight, customs value. Multiple positions only possible for shipments using
 * DHL Paket International (V53WPAK). Shipments using DHL Europaket (V54EPAK) can only contain one ExportDocPosition.
 * @subpackage Structs
 */
class ExportDocPosition extends AbstractStructBase
{
    /**
     * The description
     * Meta information extracted from the WSDL
     * - documentation: Description of the goods
     * - base: xs:string
     * - maxLength: 256
     * @var string
     */
    public $description;
    /**
     * The countryCodeOrigin
     * Meta information extracted from the WSDL
     * - documentation: ISO-Code (ISO 3166-2) of country the goods were manufactured
     * - base: xs:string
     * - maxLength: 2
     * - minLength: 2
     * @var string
     */
    public $countryCodeOrigin;
    /**
     * The customsTariffNumber
     * Meta information extracted from the WSDL
     * - documentation: Customs tariff number of the unit / position. If the service PDDP is used, customsTariffNumber is required.
     * - base: xs:string
     * - maxLength: 10
     * @var string
     */
    public $customsTariffNumber;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - documentation: Quantity of the unit / position. Only positive values (> 0) are allowed.
     * - base: xs:integer
     * - minInclusive: 1
     * - totalDigits: 10
     * @var int
     */
    public $amount;
    /**
     * The netWeightInKG
     * Meta information extracted from the WSDL
     * - documentation: Net weight of the unit / position. Only positive values (> 0) are allowed.The total net weight must not exceed the shipment weight
     * - base: xs:decimal
     * - fractionDigits: 3
     * - maxInclusive: 999999.999
     * - minInclusive: 0.000
     * @var float
     */
    public $netWeightInKG;
    /**
     * The customsValue
     * Meta information extracted from the WSDL
     * - documentation: Customs value amount of the unit /position. Only positive values (> 0) are allowed.
     * - base: xs:decimal
     * - fractionDigits: 2
     * - maxInclusive: 999999.99
     * - minInclusive: 0.0
     * @var float
     */
    public $customsValue;
    /**
     * Constructor method for ExportDocPosition
     * @uses ExportDocPosition::setDescription()
     * @uses ExportDocPosition::setCountryCodeOrigin()
     * @uses ExportDocPosition::setCustomsTariffNumber()
     * @uses ExportDocPosition::setAmount()
     * @uses ExportDocPosition::setNetWeightInKG()
     * @uses ExportDocPosition::setCustomsValue()
     * @param string $description
     * @param string $countryCodeOrigin
     * @param string $customsTariffNumber
     * @param int $amount
     * @param float $netWeightInKG
     * @param float $customsValue
     */
    public function __construct($description = null, $countryCodeOrigin = null, $customsTariffNumber = null, $amount = null, $netWeightInKG = null, $customsValue = null)
    {
        $this
            ->setDescription($description)
            ->setCountryCodeOrigin($countryCodeOrigin)
            ->setCustomsTariffNumber($customsTariffNumber)
            ->setAmount($amount)
            ->setNetWeightInKG($netWeightInKG)
            ->setCustomsValue($customsValue);
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\ExportDocPosition
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($description) && mb_strlen($description) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get countryCodeOrigin value
     * @return string|null
     */
    public function getCountryCodeOrigin()
    {
        return $this->countryCodeOrigin;
    }
    /**
     * Set countryCodeOrigin value
     * @param string $countryCodeOrigin
     * @return \StructType\ExportDocPosition
     */
    public function setCountryCodeOrigin($countryCodeOrigin = null)
    {
        // validation for constraint: string
        if (!is_null($countryCodeOrigin) && !is_string($countryCodeOrigin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCodeOrigin, true), gettype($countryCodeOrigin)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($countryCodeOrigin) && mb_strlen($countryCodeOrigin) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($countryCodeOrigin)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($countryCodeOrigin) && mb_strlen($countryCodeOrigin) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($countryCodeOrigin)), __LINE__);
        }
        $this->countryCodeOrigin = $countryCodeOrigin;
        return $this;
    }
    /**
     * Get customsTariffNumber value
     * @return string|null
     */
    public function getCustomsTariffNumber()
    {
        return $this->customsTariffNumber;
    }
    /**
     * Set customsTariffNumber value
     * @param string $customsTariffNumber
     * @return \StructType\ExportDocPosition
     */
    public function setCustomsTariffNumber($customsTariffNumber = null)
    {
        // validation for constraint: string
        if (!is_null($customsTariffNumber) && !is_string($customsTariffNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customsTariffNumber, true), gettype($customsTariffNumber)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($customsTariffNumber) && mb_strlen($customsTariffNumber) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($customsTariffNumber)), __LINE__);
        }
        $this->customsTariffNumber = $customsTariffNumber;
        return $this;
    }
    /**
     * Get amount value
     * @return int|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param int $amount
     * @return \StructType\ExportDocPosition
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($amount) && $amount < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($amount, true)), __LINE__);
        }
        // validation for constraint: totalDigits(10)
        if (!is_null($amount) && mb_strlen(preg_replace('/(\D)/', '', $amount)) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 10 digits, "%d" given', var_export($amount, true), mb_strlen(preg_replace('/(\D)/', '', $amount))), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get netWeightInKG value
     * @return float|null
     */
    public function getNetWeightInKG()
    {
        return $this->netWeightInKG;
    }
    /**
     * Set netWeightInKG value
     * @param float $netWeightInKG
     * @return \StructType\ExportDocPosition
     */
    public function setNetWeightInKG($netWeightInKG = null)
    {
        // validation for constraint: float
        if (!is_null($netWeightInKG) && !(is_float($netWeightInKG) || is_numeric($netWeightInKG))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($netWeightInKG, true), gettype($netWeightInKG)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($netWeightInKG) && mb_strlen(mb_substr($netWeightInKG, false !== mb_strpos($netWeightInKG, '.') ? mb_strpos($netWeightInKG, '.') + 1 : mb_strlen($netWeightInKG))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($netWeightInKG, true), mb_strlen(mb_substr($netWeightInKG, mb_strpos($netWeightInKG, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive(999999.999)
        if (!is_null($netWeightInKG) && $netWeightInKG > 999999.999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999999.999', var_export($netWeightInKG, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.000)
        if (!is_null($netWeightInKG) && $netWeightInKG < 0.000) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.000', var_export($netWeightInKG, true)), __LINE__);
        }
        $this->netWeightInKG = $netWeightInKG;
        return $this;
    }
    /**
     * Get customsValue value
     * @return float|null
     */
    public function getCustomsValue()
    {
        return $this->customsValue;
    }
    /**
     * Set customsValue value
     * @param float $customsValue
     * @return \StructType\ExportDocPosition
     */
    public function setCustomsValue($customsValue = null)
    {
        // validation for constraint: float
        if (!is_null($customsValue) && !(is_float($customsValue) || is_numeric($customsValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($customsValue, true), gettype($customsValue)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($customsValue) && mb_strlen(mb_substr($customsValue, false !== mb_strpos($customsValue, '.') ? mb_strpos($customsValue, '.') + 1 : mb_strlen($customsValue))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($customsValue, true), mb_strlen(mb_substr($customsValue, mb_strpos($customsValue, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive(999999.99)
        if (!is_null($customsValue) && $customsValue > 999999.99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999999.99', var_export($customsValue, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.0)
        if (!is_null($customsValue) && $customsValue < 0.0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.0', var_export($customsValue, true)), __LINE__);
        }
        $this->customsValue = $customsValue;
        return $this;
    }
}
