<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryAddressType StructType
 * Meta information extracted from the WSDL
 * - documentation: can be | includes | Type of delivery address
 * @subpackage Structs
 */
class DeliveryAddressType extends AbstractStructBase
{
    /**
     * The NativeAddress
     * Meta information extracted from the WSDL
     * - documentation: Default address
     * - choice: NativeAddress | PostOffice | PackStation
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\NativeAddressType
     */
    public $NativeAddress;
    /**
     * The PostOffice
     * Meta information extracted from the WSDL
     * - documentation: Postoffice address
     * - choice: NativeAddress | PostOffice | PackStation
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\PostfilialeType
     */
    public $PostOffice;
    /**
     * The PackStation
     * Meta information extracted from the WSDL
     * - documentation: Packstation address
     * - choice: NativeAddress | PostOffice | PackStation
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\PackStationType
     */
    public $PackStation;
    /**
     * The streetNameCode
     * Meta information extracted from the WSDL
     * - documentation: Code for street name (part of routecode).
     * - base: xs:string
     * - maxLength: 3
     * - minLength: 3
     * - minOccurs: 0
     * - ref: cis:streetNameCode
     * @var string
     */
    public $streetNameCode;
    /**
     * The streetNumberCode
     * Meta information extracted from the WSDL
     * - documentation: Code for street number (part of routecode).
     * - base: xs:string
     * - maxLength: 3
     * - minLength: 3
     * - minOccurs: 0
     * - ref: cis:streetNumberCode
     * @var string
     */
    public $streetNumberCode;
    /**
     * Constructor method for DeliveryAddressType
     * @uses DeliveryAddressType::setNativeAddress()
     * @uses DeliveryAddressType::setPostOffice()
     * @uses DeliveryAddressType::setPackStation()
     * @uses DeliveryAddressType::setStreetNameCode()
     * @uses DeliveryAddressType::setStreetNumberCode()
     * @param \StructType\NativeAddressType $nativeAddress
     * @param \StructType\PostfilialeType $postOffice
     * @param \StructType\PackStationType $packStation
     * @param string $streetNameCode
     * @param string $streetNumberCode
     */
    public function __construct(\StructType\NativeAddressType $nativeAddress = null, \StructType\PostfilialeType $postOffice = null, \StructType\PackStationType $packStation = null, $streetNameCode = null, $streetNumberCode = null)
    {
        $this
            ->setNativeAddress($nativeAddress)
            ->setPostOffice($postOffice)
            ->setPackStation($packStation)
            ->setStreetNameCode($streetNameCode)
            ->setStreetNumberCode($streetNumberCode);
    }
    /**
     * Get NativeAddress value
     * @return \StructType\NativeAddressType|null
     */
    public function getNativeAddress()
    {
        return isset($this->NativeAddress) ? $this->NativeAddress : null;
    }
    /**
     * This method is responsible for validating the value passed to the setNativeAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNativeAddress method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateNativeAddressForChoiceConstraintsFromSetNativeAddress($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'PostOffice',
            'PackStation',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property NativeAddress can\'t be set as the property %s is already set. Only one property must be set among these properties: NativeAddress, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set NativeAddress value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\NativeAddressType $nativeAddress
     * @return \StructType\DeliveryAddressType
     */
    public function setNativeAddress(\StructType\NativeAddressType $nativeAddress = null)
    {
        // validation for constraint: choice(NativeAddress, PostOffice, PackStation)
        if ('' !== ($nativeAddressChoiceErrorMessage = self::validateNativeAddressForChoiceConstraintsFromSetNativeAddress($nativeAddress))) {
            throw new \InvalidArgumentException($nativeAddressChoiceErrorMessage, __LINE__);
        }
        if (is_null($nativeAddress) || (is_array($nativeAddress) && empty($nativeAddress))) {
            unset($this->NativeAddress);
        } else {
            $this->NativeAddress = $nativeAddress;
        }
        return $this;
    }
    /**
     * Get PostOffice value
     * @return \StructType\PostfilialeType|null
     */
    public function getPostOffice()
    {
        return isset($this->PostOffice) ? $this->PostOffice : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPostOffice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPostOffice method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePostOfficeForChoiceConstraintsFromSetPostOffice($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'NativeAddress',
            'PackStation',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PostOffice can\'t be set as the property %s is already set. Only one property must be set among these properties: PostOffice, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PostOffice value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PostfilialeType $postOffice
     * @return \StructType\DeliveryAddressType
     */
    public function setPostOffice(\StructType\PostfilialeType $postOffice = null)
    {
        // validation for constraint: choice(NativeAddress, PostOffice, PackStation)
        if ('' !== ($postOfficeChoiceErrorMessage = self::validatePostOfficeForChoiceConstraintsFromSetPostOffice($postOffice))) {
            throw new \InvalidArgumentException($postOfficeChoiceErrorMessage, __LINE__);
        }
        if (is_null($postOffice) || (is_array($postOffice) && empty($postOffice))) {
            unset($this->PostOffice);
        } else {
            $this->PostOffice = $postOffice;
        }
        return $this;
    }
    /**
     * Get PackStation value
     * @return \StructType\PackStationType|null
     */
    public function getPackStation()
    {
        return isset($this->PackStation) ? $this->PackStation : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPackStation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackStation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePackStationForChoiceConstraintsFromSetPackStation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'NativeAddress',
            'PostOffice',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PackStation can\'t be set as the property %s is already set. Only one property must be set among these properties: PackStation, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PackStation value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PackStationType $packStation
     * @return \StructType\DeliveryAddressType
     */
    public function setPackStation(\StructType\PackStationType $packStation = null)
    {
        // validation for constraint: choice(NativeAddress, PostOffice, PackStation)
        if ('' !== ($packStationChoiceErrorMessage = self::validatePackStationForChoiceConstraintsFromSetPackStation($packStation))) {
            throw new \InvalidArgumentException($packStationChoiceErrorMessage, __LINE__);
        }
        if (is_null($packStation) || (is_array($packStation) && empty($packStation))) {
            unset($this->PackStation);
        } else {
            $this->PackStation = $packStation;
        }
        return $this;
    }
    /**
     * Get streetNameCode value
     * @return string|null
     */
    public function getStreetNameCode()
    {
        return $this->streetNameCode;
    }
    /**
     * Set streetNameCode value
     * @param string $streetNameCode
     * @return \StructType\DeliveryAddressType
     */
    public function setStreetNameCode($streetNameCode = null)
    {
        // validation for constraint: string
        if (!is_null($streetNameCode) && !is_string($streetNameCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetNameCode, true), gettype($streetNameCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($streetNameCode) && mb_strlen($streetNameCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($streetNameCode)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($streetNameCode) && mb_strlen($streetNameCode) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($streetNameCode)), __LINE__);
        }
        $this->streetNameCode = $streetNameCode;
        return $this;
    }
    /**
     * Get streetNumberCode value
     * @return string|null
     */
    public function getStreetNumberCode()
    {
        return $this->streetNumberCode;
    }
    /**
     * Set streetNumberCode value
     * @param string $streetNumberCode
     * @return \StructType\DeliveryAddressType
     */
    public function setStreetNumberCode($streetNumberCode = null)
    {
        // validation for constraint: string
        if (!is_null($streetNumberCode) && !is_string($streetNumberCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetNumberCode, true), gettype($streetNumberCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($streetNumberCode) && mb_strlen($streetNumberCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($streetNumberCode)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($streetNumberCode) && mb_strlen($streetNumberCode) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($streetNumberCode)), __LINE__);
        }
        $this->streetNumberCode = $streetNumberCode;
        return $this;
    }
}
