<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteShipmentOrderResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: The version of the webservice implementation. | The status of the operation.
 * @subpackage Structs
 */
class DeleteShipmentOrderResponse extends AbstractStructBase
{
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - ref: bcs:Version
     * @var \StructType\Version
     */
    public $Version;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Success status after processing the overall request.
     * @var \StructType\Statusinformation
     */
    public $Status;
    /**
     * The DeletionState
     * Meta information extracted from the WSDL
     * - documentation: For every ShipmentNumber requested, one DeletionState node is returned that contains the status of the respective deletion operation.
     * - maxOccurs: 30
     * - minOccurs: 0
     * @var \StructType\DeletionState[]
     */
    public $DeletionState;
    /**
     * Constructor method for DeleteShipmentOrderResponse
     * @uses DeleteShipmentOrderResponse::setVersion()
     * @uses DeleteShipmentOrderResponse::setStatus()
     * @uses DeleteShipmentOrderResponse::setDeletionState()
     * @param \StructType\Version $version
     * @param \StructType\Statusinformation $status
     * @param \StructType\DeletionState[] $deletionState
     */
    public function __construct(\StructType\Version $version = null, \StructType\Statusinformation $status = null, array $deletionState = array())
    {
        $this
            ->setVersion($version)
            ->setStatus($status)
            ->setDeletionState($deletionState);
    }
    /**
     * Get Version value
     * @return \StructType\Version|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param \StructType\Version $version
     * @return \StructType\DeleteShipmentOrderResponse
     */
    public function setVersion(\StructType\Version $version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Status value
     * @return \StructType\Statusinformation|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\Statusinformation $status
     * @return \StructType\DeleteShipmentOrderResponse
     */
    public function setStatus(\StructType\Statusinformation $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get DeletionState value
     * @return \StructType\DeletionState[]|null
     */
    public function getDeletionState()
    {
        return $this->DeletionState;
    }
    /**
     * This method is responsible for validating the values passed to the setDeletionState method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeletionState method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeletionStateForArrayConstraintsFromSetDeletionState(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $deleteShipmentOrderResponseDeletionStateItem) {
            // validation for constraint: itemType
            if (!$deleteShipmentOrderResponseDeletionStateItem instanceof \StructType\DeletionState) {
                $invalidValues[] = is_object($deleteShipmentOrderResponseDeletionStateItem) ? get_class($deleteShipmentOrderResponseDeletionStateItem) : sprintf('%s(%s)', gettype($deleteShipmentOrderResponseDeletionStateItem), var_export($deleteShipmentOrderResponseDeletionStateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DeletionState property can only contain items of type \StructType\DeletionState, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DeletionState value
     * @throws \InvalidArgumentException
     * @param \StructType\DeletionState[] $deletionState
     * @return \StructType\DeleteShipmentOrderResponse
     */
    public function setDeletionState(array $deletionState = array())
    {
        // validation for constraint: array
        if ('' !== ($deletionStateArrayErrorMessage = self::validateDeletionStateForArrayConstraintsFromSetDeletionState($deletionState))) {
            throw new \InvalidArgumentException($deletionStateArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($deletionState) && count($deletionState) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 30', count($deletionState)), __LINE__);
        }
        $this->DeletionState = $deletionState;
        return $this;
    }
    /**
     * Add item to DeletionState value
     * @throws \InvalidArgumentException
     * @param \StructType\DeletionState $item
     * @return \StructType\DeleteShipmentOrderResponse
     */
    public function addToDeletionState(\StructType\DeletionState $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DeletionState) {
            throw new \InvalidArgumentException(sprintf('The DeletionState property can only contain items of type \StructType\DeletionState, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($this->DeletionState) && count($this->DeletionState) >= 30) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 30', count($this->DeletionState)), __LINE__);
        }
        $this->DeletionState[] = $item;
        return $this;
    }
}
