<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteShipmentOrderRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: In order to delete previously created DD shipment orders, ShipmentNumber. ShipmentNumber is required. This parent element inherits from ShipmentNumberType, therefore all following subelements are valid according to schema, however
 * the web service accepts shipmentNumber only. Note: you can delete more than one shipment by passing multiple ShipmentNumber containers. | The version of the webservice implementation for which the requesting client is developed. | The identifier for
 * the shipment which should be deleted.
 * @subpackage Structs
 */
class DeleteShipmentOrderRequest extends AbstractStructBase
{
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - ref: bcs:Version
     * @var \StructType\Version
     */
    public $Version;
    /**
     * The shipmentNumber
     * Meta information extracted from the WSDL
     * - documentation: Can contain any DHL shipmentnumber. | Can contain any DHL shipmentnumber. For successful and unsuccessful operations, the requested ShipmentNumber to be deleted is returned. This is no matter if the operation could be performed or
     * not.
     * - base: xs:string
     * - maxLength: 39
     * - maxOccurs: 30
     * - ref: cis:shipmentNumber
     * @var string[]
     */
    public $shipmentNumber;
    /**
     * Constructor method for DeleteShipmentOrderRequest
     * @uses DeleteShipmentOrderRequest::setVersion()
     * @uses DeleteShipmentOrderRequest::setShipmentNumber()
     * @param \StructType\Version $version
     * @param string[] $shipmentNumber
     */
    public function __construct(\StructType\Version $version = null, array $shipmentNumber = array())
    {
        $this
            ->setVersion($version)
            ->setShipmentNumber($shipmentNumber);
    }
    /**
     * Get Version value
     * @return \StructType\Version|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param \StructType\Version $version
     * @return \StructType\DeleteShipmentOrderRequest
     */
    public function setVersion(\StructType\Version $version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get shipmentNumber value
     * @return string[]|null
     */
    public function getShipmentNumber()
    {
        return $this->shipmentNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setShipmentNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentNumberForArrayConstraintsFromSetShipmentNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $deleteShipmentOrderRequestShipmentNumberItem) {
            // validation for constraint: itemType
            if (!is_string($deleteShipmentOrderRequestShipmentNumberItem)) {
                $invalidValues[] = is_object($deleteShipmentOrderRequestShipmentNumberItem) ? get_class($deleteShipmentOrderRequestShipmentNumberItem) : sprintf('%s(%s)', gettype($deleteShipmentOrderRequestShipmentNumberItem), var_export($deleteShipmentOrderRequestShipmentNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The shipmentNumber property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setShipmentNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentNumber method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentNumberForMaxLengthConstraintFromSetShipmentNumber($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $deleteShipmentOrderRequestShipmentNumberItem) {
            // validation for constraint: maxLength(39)
            if (mb_strlen($deleteShipmentOrderRequestShipmentNumberItem) > 39) {
                $invalidValues[] = var_export($deleteShipmentOrderRequestShipmentNumberItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 39', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set shipmentNumber value
     * @throws \InvalidArgumentException
     * @param string[] $shipmentNumber
     * @return \StructType\DeleteShipmentOrderRequest
     */
    public function setShipmentNumber(array $shipmentNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentNumberArrayErrorMessage = self::validateShipmentNumberForArrayConstraintsFromSetShipmentNumber($shipmentNumber))) {
            throw new \InvalidArgumentException($shipmentNumberArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(39)
        if ('' !== ($shipmentNumberMaxLengthErrorMessage = self::validateShipmentNumberForMaxLengthConstraintFromSetShipmentNumber($shipmentNumber))) {
            throw new \InvalidArgumentException($shipmentNumberMaxLengthErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($shipmentNumber) && count($shipmentNumber) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 30', count($shipmentNumber)), __LINE__);
        }
        $this->shipmentNumber = $shipmentNumber;
        return $this;
    }
    /**
     * Add item to shipmentNumber value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\DeleteShipmentOrderRequest
     */
    public function addToShipmentNumber($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The shipmentNumber property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(39)
        if (mb_strlen($item) > 39) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 39', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($this->shipmentNumber) && count($this->shipmentNumber) >= 30) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 30', count($this->shipmentNumber)), __LINE__);
        }
        $this->shipmentNumber[] = $item;
        return $this;
    }
}
