<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerType StructType
 * Meta information extracted from the WSDL
 * - documentation: includes | Type of customer
 * @subpackage Structs
 */
class CustomerType extends AbstractStructBase
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Name of customer.
     * @var \StructType\NameType
     */
    public $Name;
    /**
     * The vatID
     * Meta information extracted from the WSDL
     * - documentation: VAT id.
     * - minOccurs: 0
     * @var string
     */
    public $vatID;
    /**
     * The EKP
     * Meta information extracted from the WSDL
     * - documentation: First 10 digit number extract from the 14 digit DHL Account Number. E.g. if DHL Account Number is "5000000008 72 01" then EKP is equal to 5000000008.
     * - base: xs:string
     * - maxLength: 10
     * - minLength: 10
     * - ref: cis:EKP
     * @var string
     */
    public $EKP;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - documentation: Address of customer
     * @var \StructType\NativeAddressType
     */
    public $Address;
    /**
     * The Contact
     * Meta information extracted from the WSDL
     * - documentation: Contact information
     * @var \StructType\ContactType
     */
    public $Contact;
    /**
     * The Bank
     * Meta information extracted from the WSDL
     * - documentation: Bank information
     * - minOccurs: 0
     * @var \StructType\BankType
     */
    public $Bank;
    /**
     * The note
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $note;
    /**
     * Constructor method for CustomerType
     * @uses CustomerType::setName()
     * @uses CustomerType::setVatID()
     * @uses CustomerType::setEKP()
     * @uses CustomerType::setAddress()
     * @uses CustomerType::setContact()
     * @uses CustomerType::setBank()
     * @uses CustomerType::setNote()
     * @param \StructType\NameType $name
     * @param string $vatID
     * @param string $eKP
     * @param \StructType\NativeAddressType $address
     * @param \StructType\ContactType $contact
     * @param \StructType\BankType $bank
     * @param mixed $note
     */
    public function __construct(\StructType\NameType $name = null, $vatID = null, $eKP = null, \StructType\NativeAddressType $address = null, \StructType\ContactType $contact = null, \StructType\BankType $bank = null, $note = null)
    {
        $this
            ->setName($name)
            ->setVatID($vatID)
            ->setEKP($eKP)
            ->setAddress($address)
            ->setContact($contact)
            ->setBank($bank)
            ->setNote($note);
    }
    /**
     * Get Name value
     * @return \StructType\NameType|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param \StructType\NameType $name
     * @return \StructType\CustomerType
     */
    public function setName(\StructType\NameType $name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get vatID value
     * @return string|null
     */
    public function getVatID()
    {
        return $this->vatID;
    }
    /**
     * Set vatID value
     * @param string $vatID
     * @return \StructType\CustomerType
     */
    public function setVatID($vatID = null)
    {
        // validation for constraint: string
        if (!is_null($vatID) && !is_string($vatID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vatID, true), gettype($vatID)), __LINE__);
        }
        $this->vatID = $vatID;
        return $this;
    }
    /**
     * Get EKP value
     * @return string|null
     */
    public function getEKP()
    {
        return $this->EKP;
    }
    /**
     * Set EKP value
     * @param string $eKP
     * @return \StructType\CustomerType
     */
    public function setEKP($eKP = null)
    {
        // validation for constraint: string
        if (!is_null($eKP) && !is_string($eKP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eKP, true), gettype($eKP)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($eKP) && mb_strlen($eKP) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($eKP)), __LINE__);
        }
        // validation for constraint: minLength(10)
        if (!is_null($eKP) && mb_strlen($eKP) < 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 10', mb_strlen($eKP)), __LINE__);
        }
        $this->EKP = $eKP;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\NativeAddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\NativeAddressType $address
     * @return \StructType\CustomerType
     */
    public function setAddress(\StructType\NativeAddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Contact value
     * @return \StructType\ContactType|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \StructType\ContactType $contact
     * @return \StructType\CustomerType
     */
    public function setContact(\StructType\ContactType $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get Bank value
     * @return \StructType\BankType|null
     */
    public function getBank()
    {
        return $this->Bank;
    }
    /**
     * Set Bank value
     * @param \StructType\BankType $bank
     * @return \StructType\CustomerType
     */
    public function setBank(\StructType\BankType $bank = null)
    {
        $this->Bank = $bank;
        return $this;
    }
    /**
     * Get note value
     * @return mixed|null
     */
    public function getNote()
    {
        return $this->note;
    }
    /**
     * Set note value
     * @param mixed $note
     * @return \StructType\CustomerType
     */
    public function setNote($note = null)
    {
        $this->note = $note;
        return $this;
    }
}
