<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BankType StructType
 * Meta information extracted from the WSDL
 * - documentation: includes | Type of bank information
 * @subpackage Structs
 */
class BankType extends AbstractStructBase
{
    /**
     * The accountOwner
     * Meta information extracted from the WSDL
     * - documentation: Name of bank account owner.
     * - base: xs:string
     * - maxLength: 80
     * @var string
     */
    public $accountOwner;
    /**
     * The bankName
     * Meta information extracted from the WSDL
     * - documentation: Name of bank.
     * - base: xs:string
     * - maxLength: 80
     * @var string
     */
    public $bankName;
    /**
     * The iban
     * Meta information extracted from the WSDL
     * - documentation: IBAN code of bank account.
     * - base: xs:string
     * - maxLength: 22
     * @var string
     */
    public $iban;
    /**
     * The note1
     * Meta information extracted from the WSDL
     * - documentation: Purpose of bank information.
     * - base: xs:string
     * - maxLength: 35
     * - minOccurs: 0
     * @var string
     */
    public $note1;
    /**
     * The note2
     * Meta information extracted from the WSDL
     * - documentation: Purpose of bank information.
     * - base: xs:string
     * - maxLength: 35
     * - minOccurs: 0
     * @var string
     */
    public $note2;
    /**
     * The bic
     * Meta information extracted from the WSDL
     * - documentation: Bank-Information-Code (BankCCL) of bank account.
     * - base: xs:string
     * - maxLength: 11
     * - minOccurs: 0
     * @var string
     */
    public $bic;
    /**
     * The accountreference
     * Meta information extracted from the WSDL
     * - documentation: Accountreferece to customer profile
     * - base: xs:string
     * - maxLength: 35
     * - minOccurs: 0
     * @var string
     */
    public $accountreference;
    /**
     * Constructor method for BankType
     * @uses BankType::setAccountOwner()
     * @uses BankType::setBankName()
     * @uses BankType::setIban()
     * @uses BankType::setNote1()
     * @uses BankType::setNote2()
     * @uses BankType::setBic()
     * @uses BankType::setAccountreference()
     * @param string $accountOwner
     * @param string $bankName
     * @param string $iban
     * @param string $note1
     * @param string $note2
     * @param string $bic
     * @param string $accountreference
     */
    public function __construct($accountOwner = null, $bankName = null, $iban = null, $note1 = null, $note2 = null, $bic = null, $accountreference = null)
    {
        $this
            ->setAccountOwner($accountOwner)
            ->setBankName($bankName)
            ->setIban($iban)
            ->setNote1($note1)
            ->setNote2($note2)
            ->setBic($bic)
            ->setAccountreference($accountreference);
    }
    /**
     * Get accountOwner value
     * @return string|null
     */
    public function getAccountOwner()
    {
        return $this->accountOwner;
    }
    /**
     * Set accountOwner value
     * @param string $accountOwner
     * @return \StructType\BankType
     */
    public function setAccountOwner($accountOwner = null)
    {
        // validation for constraint: string
        if (!is_null($accountOwner) && !is_string($accountOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountOwner, true), gettype($accountOwner)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($accountOwner) && mb_strlen($accountOwner) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($accountOwner)), __LINE__);
        }
        $this->accountOwner = $accountOwner;
        return $this;
    }
    /**
     * Get bankName value
     * @return string|null
     */
    public function getBankName()
    {
        return $this->bankName;
    }
    /**
     * Set bankName value
     * @param string $bankName
     * @return \StructType\BankType
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankName, true), gettype($bankName)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($bankName) && mb_strlen($bankName) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($bankName)), __LINE__);
        }
        $this->bankName = $bankName;
        return $this;
    }
    /**
     * Get iban value
     * @return string|null
     */
    public function getIban()
    {
        return $this->iban;
    }
    /**
     * Set iban value
     * @param string $iban
     * @return \StructType\BankType
     */
    public function setIban($iban = null)
    {
        // validation for constraint: string
        if (!is_null($iban) && !is_string($iban)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iban, true), gettype($iban)), __LINE__);
        }
        // validation for constraint: maxLength(22)
        if (!is_null($iban) && mb_strlen($iban) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 22', mb_strlen($iban)), __LINE__);
        }
        $this->iban = $iban;
        return $this;
    }
    /**
     * Get note1 value
     * @return string|null
     */
    public function getNote1()
    {
        return $this->note1;
    }
    /**
     * Set note1 value
     * @param string $note1
     * @return \StructType\BankType
     */
    public function setNote1($note1 = null)
    {
        // validation for constraint: string
        if (!is_null($note1) && !is_string($note1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note1, true), gettype($note1)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($note1) && mb_strlen($note1) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($note1)), __LINE__);
        }
        $this->note1 = $note1;
        return $this;
    }
    /**
     * Get note2 value
     * @return string|null
     */
    public function getNote2()
    {
        return $this->note2;
    }
    /**
     * Set note2 value
     * @param string $note2
     * @return \StructType\BankType
     */
    public function setNote2($note2 = null)
    {
        // validation for constraint: string
        if (!is_null($note2) && !is_string($note2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note2, true), gettype($note2)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($note2) && mb_strlen($note2) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($note2)), __LINE__);
        }
        $this->note2 = $note2;
        return $this;
    }
    /**
     * Get bic value
     * @return string|null
     */
    public function getBic()
    {
        return $this->bic;
    }
    /**
     * Set bic value
     * @param string $bic
     * @return \StructType\BankType
     */
    public function setBic($bic = null)
    {
        // validation for constraint: string
        if (!is_null($bic) && !is_string($bic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bic, true), gettype($bic)), __LINE__);
        }
        // validation for constraint: maxLength(11)
        if (!is_null($bic) && mb_strlen($bic) > 11) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 11', mb_strlen($bic)), __LINE__);
        }
        $this->bic = $bic;
        return $this;
    }
    /**
     * Get accountreference value
     * @return string|null
     */
    public function getAccountreference()
    {
        return $this->accountreference;
    }
    /**
     * Set accountreference value
     * @param string $accountreference
     * @return \StructType\BankType
     */
    public function setAccountreference($accountreference = null)
    {
        // validation for constraint: string
        if (!is_null($accountreference) && !is_string($accountreference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountreference, true), gettype($accountreference)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($accountreference) && mb_strlen($accountreference) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($accountreference)), __LINE__);
        }
        $this->accountreference = $accountreference;
        return $this;
    }
}
