<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Sets the Authentification SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\AuthentificationType $authentification
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentification(\StructType\AuthentificationType $authentification, $nameSpace = 'http://dhl.de/webservice/cisbase', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Authentification', $authentification, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named deleteShipmentOrder
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentification
     * - SOAPHeaderNamespaces: http://dhl.de/webservice/cisbase
     * - SOAPHeaderTypes: \StructType\AuthentificationType
     * - SOAPHeaders: required
     * - documentation: Deletes the requested shipments. | The identifier for the shipment which should be deleted. | The status of the deletion operation. | Deletes the requested shipments. | The authentication data and the shipment identifier. | The
     * status of the operation.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteShipmentOrderRequest $part1
     * @return \StructType\DeleteShipmentOrderResponse|bool
     */
    public function deleteShipmentOrder(\StructType\DeleteShipmentOrderRequest $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteShipmentOrder($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DeleteShipmentOrderResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
