<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for termsOfTrade EnumType
 * Meta information extracted from the WSDL
 * - documentation: Element provides terms of trades, incoterms codes: DDP (Delivery Duty Paid) DXV (Delivery Duty Paid (excl. VAT)) DAP (formerly DDU, Delivery At Place) DDX (Delivery Duty Paid (excl. Duties, taxes and VAT) CPT (Carriage Paid To
 * (within EU only)) are vaild values.
 * @subpackage Enumerations
 */
class TermsOfTrade extends AbstractStructEnumBase
{
    /**
     * Constant for value 'DDP'
     * @return string 'DDP'
     */
    const VALUE_DDP = 'DDP';
    /**
     * Constant for value 'DXV'
     * @return string 'DXV'
     */
    const VALUE_DXV = 'DXV';
    /**
     * Constant for value 'DAP'
     * @return string 'DAP'
     */
    const VALUE_DAP = 'DAP';
    /**
     * Constant for value 'DDX'
     * @return string 'DDX'
     */
    const VALUE_DDX = 'DDX';
    /**
     * Constant for value 'CPT'
     * @return string 'CPT'
     */
    const VALUE_CPT = 'CPT';
    /**
     * Return allowed values
     * @uses self::VALUE_DDP
     * @uses self::VALUE_DXV
     * @uses self::VALUE_DAP
     * @uses self::VALUE_DDX
     * @uses self::VALUE_CPT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DDP,
            self::VALUE_DXV,
            self::VALUE_DAP,
            self::VALUE_DDX,
            self::VALUE_CPT,
        );
    }
}
