<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentService StructType
 * Meta information extracted from the WSDL
 * - documentation: can be | GKV shipment services.
 * @subpackage Structs
 */
class ShipmentService extends AbstractStructBase
{
    /**
     * The IndividualSenderRequirement
     * Meta information extracted from the WSDL
     * - documentation: This service is used exclusively for shipments with special delivery requirements. It is not available for our regular business customers.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ServiceconfigurationISR
     */
    public $IndividualSenderRequirement;
    /**
     * The PackagingReturn
     * Meta information extracted from the WSDL
     * - documentation: Service for package return. For packagingReturn you also have to book a return label.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Serviceconfiguration
     */
    public $PackagingReturn;
    /**
     * The Endorsement
     * Meta information extracted from the WSDL
     * - documentation: Service "Endorsement". Mandatory for shipments with product DHL Paket International: V53WPAK
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ServiceconfigurationEndorsement
     */
    public $Endorsement;
    /**
     * The VisualCheckOfAge
     * Meta information extracted from the WSDL
     * - documentation: Service visual age check
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ServiceconfigurationVisualAgeCheck
     */
    public $VisualCheckOfAge;
    /**
     * The PreferredLocation
     * Meta information extracted from the WSDL
     * - documentation: Service preferred location
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ServiceconfigurationDetailsPreferredLocation
     */
    public $PreferredLocation;
    /**
     * The PreferredNeighbour
     * Meta information extracted from the WSDL
     * - documentation: The details field should be set to the preferred neighbours name. | Service preferred neighbour
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ServiceconfigurationDetailsPreferredNeighbour
     */
    public $PreferredNeighbour;
    /**
     * The PreferredDay
     * Meta information extracted from the WSDL
     * - documentation: Service preferred day
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ServiceconfigurationDetailsPreferredDay
     */
    public $PreferredDay;
    /**
     * The NoNeighbourDelivery
     * Meta information extracted from the WSDL
     * - documentation: Invoke service No Neighbour Delivery.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Serviceconfiguration
     */
    public $NoNeighbourDelivery;
    /**
     * The NamedPersonOnly
     * Meta information extracted from the WSDL
     * - documentation: Invoke service Named Person Only.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Serviceconfiguration
     */
    public $NamedPersonOnly;
    /**
     * The ReturnReceipt
     * Meta information extracted from the WSDL
     * - documentation: Invoke service return receipt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Serviceconfiguration
     */
    public $ReturnReceipt;
    /**
     * The Premium
     * Meta information extracted from the WSDL
     * - documentation: Premium for fast and safe delivery of international shipments.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Serviceconfiguration
     */
    public $Premium;
    /**
     * The CashOnDelivery
     * Meta information extracted from the WSDL
     * - documentation: Service Cash on delivery.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ServiceconfigurationCashOnDelivery
     */
    public $CashOnDelivery;
    /**
     * The PDDP
     * Meta information extracted from the WSDL
     * - documentation: Postal Delivery Duty Paid Deutsche Post and sender handle import duties instead of consignee
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PDDP
     */
    public $PDDP;
    /**
     * The AdditionalInsurance
     * Meta information extracted from the WSDL
     * - documentation: Insure shipment with higher than standard amount.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ServiceconfigurationAdditionalInsurance
     */
    public $AdditionalInsurance;
    /**
     * The BulkyGoods
     * Meta information extracted from the WSDL
     * - documentation: Service to ship bulky goods.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Serviceconfiguration
     */
    public $BulkyGoods;
    /**
     * The IdentCheck
     * Meta information extracted from the WSDL
     * - documentation: Service configuration for IdentCheck.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ServiceconfigurationIC
     */
    public $IdentCheck;
    /**
     * The ParcelOutletRouting
     * Meta information extracted from the WSDL
     * - documentation: Service configuration for ParcelOutletRouting. Details can be an email-address, if not set receiver email will be used
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ServiceconfigurationDetailsOptional
     */
    public $ParcelOutletRouting;
    /**
     * Constructor method for ShipmentService
     * @uses ShipmentService::setIndividualSenderRequirement()
     * @uses ShipmentService::setPackagingReturn()
     * @uses ShipmentService::setEndorsement()
     * @uses ShipmentService::setVisualCheckOfAge()
     * @uses ShipmentService::setPreferredLocation()
     * @uses ShipmentService::setPreferredNeighbour()
     * @uses ShipmentService::setPreferredDay()
     * @uses ShipmentService::setNoNeighbourDelivery()
     * @uses ShipmentService::setNamedPersonOnly()
     * @uses ShipmentService::setReturnReceipt()
     * @uses ShipmentService::setPremium()
     * @uses ShipmentService::setCashOnDelivery()
     * @uses ShipmentService::setPDDP()
     * @uses ShipmentService::setAdditionalInsurance()
     * @uses ShipmentService::setBulkyGoods()
     * @uses ShipmentService::setIdentCheck()
     * @uses ShipmentService::setParcelOutletRouting()
     * @param \StructType\ServiceconfigurationISR $individualSenderRequirement
     * @param \StructType\Serviceconfiguration $packagingReturn
     * @param \StructType\ServiceconfigurationEndorsement $endorsement
     * @param \StructType\ServiceconfigurationVisualAgeCheck $visualCheckOfAge
     * @param \StructType\ServiceconfigurationDetailsPreferredLocation $preferredLocation
     * @param \StructType\ServiceconfigurationDetailsPreferredNeighbour $preferredNeighbour
     * @param \StructType\ServiceconfigurationDetailsPreferredDay $preferredDay
     * @param \StructType\Serviceconfiguration $noNeighbourDelivery
     * @param \StructType\Serviceconfiguration $namedPersonOnly
     * @param \StructType\Serviceconfiguration $returnReceipt
     * @param \StructType\Serviceconfiguration $premium
     * @param \StructType\ServiceconfigurationCashOnDelivery $cashOnDelivery
     * @param \StructType\PDDP $pDDP
     * @param \StructType\ServiceconfigurationAdditionalInsurance $additionalInsurance
     * @param \StructType\Serviceconfiguration $bulkyGoods
     * @param \StructType\ServiceconfigurationIC $identCheck
     * @param \StructType\ServiceconfigurationDetailsOptional $parcelOutletRouting
     */
    public function __construct(\StructType\ServiceconfigurationISR $individualSenderRequirement = null, \StructType\Serviceconfiguration $packagingReturn = null, \StructType\ServiceconfigurationEndorsement $endorsement = null, \StructType\ServiceconfigurationVisualAgeCheck $visualCheckOfAge = null, \StructType\ServiceconfigurationDetailsPreferredLocation $preferredLocation = null, \StructType\ServiceconfigurationDetailsPreferredNeighbour $preferredNeighbour = null, \StructType\ServiceconfigurationDetailsPreferredDay $preferredDay = null, \StructType\Serviceconfiguration $noNeighbourDelivery = null, \StructType\Serviceconfiguration $namedPersonOnly = null, \StructType\Serviceconfiguration $returnReceipt = null, \StructType\Serviceconfiguration $premium = null, \StructType\ServiceconfigurationCashOnDelivery $cashOnDelivery = null, \StructType\PDDP $pDDP = null, \StructType\ServiceconfigurationAdditionalInsurance $additionalInsurance = null, \StructType\Serviceconfiguration $bulkyGoods = null, \StructType\ServiceconfigurationIC $identCheck = null, \StructType\ServiceconfigurationDetailsOptional $parcelOutletRouting = null)
    {
        $this
            ->setIndividualSenderRequirement($individualSenderRequirement)
            ->setPackagingReturn($packagingReturn)
            ->setEndorsement($endorsement)
            ->setVisualCheckOfAge($visualCheckOfAge)
            ->setPreferredLocation($preferredLocation)
            ->setPreferredNeighbour($preferredNeighbour)
            ->setPreferredDay($preferredDay)
            ->setNoNeighbourDelivery($noNeighbourDelivery)
            ->setNamedPersonOnly($namedPersonOnly)
            ->setReturnReceipt($returnReceipt)
            ->setPremium($premium)
            ->setCashOnDelivery($cashOnDelivery)
            ->setPDDP($pDDP)
            ->setAdditionalInsurance($additionalInsurance)
            ->setBulkyGoods($bulkyGoods)
            ->setIdentCheck($identCheck)
            ->setParcelOutletRouting($parcelOutletRouting);
    }
    /**
     * Get IndividualSenderRequirement value
     * @return \StructType\ServiceconfigurationISR|null
     */
    public function getIndividualSenderRequirement()
    {
        return $this->IndividualSenderRequirement;
    }
    /**
     * Set IndividualSenderRequirement value
     * @param \StructType\ServiceconfigurationISR $individualSenderRequirement
     * @return \StructType\ShipmentService
     */
    public function setIndividualSenderRequirement(\StructType\ServiceconfigurationISR $individualSenderRequirement = null)
    {
        $this->IndividualSenderRequirement = $individualSenderRequirement;
        return $this;
    }
    /**
     * Get PackagingReturn value
     * @return \StructType\Serviceconfiguration|null
     */
    public function getPackagingReturn()
    {
        return $this->PackagingReturn;
    }
    /**
     * Set PackagingReturn value
     * @param \StructType\Serviceconfiguration $packagingReturn
     * @return \StructType\ShipmentService
     */
    public function setPackagingReturn(\StructType\Serviceconfiguration $packagingReturn = null)
    {
        $this->PackagingReturn = $packagingReturn;
        return $this;
    }
    /**
     * Get Endorsement value
     * @return \StructType\ServiceconfigurationEndorsement|null
     */
    public function getEndorsement()
    {
        return $this->Endorsement;
    }
    /**
     * Set Endorsement value
     * @param \StructType\ServiceconfigurationEndorsement $endorsement
     * @return \StructType\ShipmentService
     */
    public function setEndorsement(\StructType\ServiceconfigurationEndorsement $endorsement = null)
    {
        $this->Endorsement = $endorsement;
        return $this;
    }
    /**
     * Get VisualCheckOfAge value
     * @return \StructType\ServiceconfigurationVisualAgeCheck|null
     */
    public function getVisualCheckOfAge()
    {
        return $this->VisualCheckOfAge;
    }
    /**
     * Set VisualCheckOfAge value
     * @param \StructType\ServiceconfigurationVisualAgeCheck $visualCheckOfAge
     * @return \StructType\ShipmentService
     */
    public function setVisualCheckOfAge(\StructType\ServiceconfigurationVisualAgeCheck $visualCheckOfAge = null)
    {
        $this->VisualCheckOfAge = $visualCheckOfAge;
        return $this;
    }
    /**
     * Get PreferredLocation value
     * @return \StructType\ServiceconfigurationDetailsPreferredLocation|null
     */
    public function getPreferredLocation()
    {
        return $this->PreferredLocation;
    }
    /**
     * Set PreferredLocation value
     * @param \StructType\ServiceconfigurationDetailsPreferredLocation $preferredLocation
     * @return \StructType\ShipmentService
     */
    public function setPreferredLocation(\StructType\ServiceconfigurationDetailsPreferredLocation $preferredLocation = null)
    {
        $this->PreferredLocation = $preferredLocation;
        return $this;
    }
    /**
     * Get PreferredNeighbour value
     * @return \StructType\ServiceconfigurationDetailsPreferredNeighbour|null
     */
    public function getPreferredNeighbour()
    {
        return $this->PreferredNeighbour;
    }
    /**
     * Set PreferredNeighbour value
     * @param \StructType\ServiceconfigurationDetailsPreferredNeighbour $preferredNeighbour
     * @return \StructType\ShipmentService
     */
    public function setPreferredNeighbour(\StructType\ServiceconfigurationDetailsPreferredNeighbour $preferredNeighbour = null)
    {
        $this->PreferredNeighbour = $preferredNeighbour;
        return $this;
    }
    /**
     * Get PreferredDay value
     * @return \StructType\ServiceconfigurationDetailsPreferredDay|null
     */
    public function getPreferredDay()
    {
        return $this->PreferredDay;
    }
    /**
     * Set PreferredDay value
     * @param \StructType\ServiceconfigurationDetailsPreferredDay $preferredDay
     * @return \StructType\ShipmentService
     */
    public function setPreferredDay(\StructType\ServiceconfigurationDetailsPreferredDay $preferredDay = null)
    {
        $this->PreferredDay = $preferredDay;
        return $this;
    }
    /**
     * Get NoNeighbourDelivery value
     * @return \StructType\Serviceconfiguration|null
     */
    public function getNoNeighbourDelivery()
    {
        return $this->NoNeighbourDelivery;
    }
    /**
     * Set NoNeighbourDelivery value
     * @param \StructType\Serviceconfiguration $noNeighbourDelivery
     * @return \StructType\ShipmentService
     */
    public function setNoNeighbourDelivery(\StructType\Serviceconfiguration $noNeighbourDelivery = null)
    {
        $this->NoNeighbourDelivery = $noNeighbourDelivery;
        return $this;
    }
    /**
     * Get NamedPersonOnly value
     * @return \StructType\Serviceconfiguration|null
     */
    public function getNamedPersonOnly()
    {
        return $this->NamedPersonOnly;
    }
    /**
     * Set NamedPersonOnly value
     * @param \StructType\Serviceconfiguration $namedPersonOnly
     * @return \StructType\ShipmentService
     */
    public function setNamedPersonOnly(\StructType\Serviceconfiguration $namedPersonOnly = null)
    {
        $this->NamedPersonOnly = $namedPersonOnly;
        return $this;
    }
    /**
     * Get ReturnReceipt value
     * @return \StructType\Serviceconfiguration|null
     */
    public function getReturnReceipt()
    {
        return $this->ReturnReceipt;
    }
    /**
     * Set ReturnReceipt value
     * @param \StructType\Serviceconfiguration $returnReceipt
     * @return \StructType\ShipmentService
     */
    public function setReturnReceipt(\StructType\Serviceconfiguration $returnReceipt = null)
    {
        $this->ReturnReceipt = $returnReceipt;
        return $this;
    }
    /**
     * Get Premium value
     * @return \StructType\Serviceconfiguration|null
     */
    public function getPremium()
    {
        return $this->Premium;
    }
    /**
     * Set Premium value
     * @param \StructType\Serviceconfiguration $premium
     * @return \StructType\ShipmentService
     */
    public function setPremium(\StructType\Serviceconfiguration $premium = null)
    {
        $this->Premium = $premium;
        return $this;
    }
    /**
     * Get CashOnDelivery value
     * @return \StructType\ServiceconfigurationCashOnDelivery|null
     */
    public function getCashOnDelivery()
    {
        return $this->CashOnDelivery;
    }
    /**
     * Set CashOnDelivery value
     * @param \StructType\ServiceconfigurationCashOnDelivery $cashOnDelivery
     * @return \StructType\ShipmentService
     */
    public function setCashOnDelivery(\StructType\ServiceconfigurationCashOnDelivery $cashOnDelivery = null)
    {
        $this->CashOnDelivery = $cashOnDelivery;
        return $this;
    }
    /**
     * Get PDDP value
     * @return \StructType\PDDP|null
     */
    public function getPDDP()
    {
        return $this->PDDP;
    }
    /**
     * Set PDDP value
     * @param \StructType\PDDP $pDDP
     * @return \StructType\ShipmentService
     */
    public function setPDDP(\StructType\PDDP $pDDP = null)
    {
        $this->PDDP = $pDDP;
        return $this;
    }
    /**
     * Get AdditionalInsurance value
     * @return \StructType\ServiceconfigurationAdditionalInsurance|null
     */
    public function getAdditionalInsurance()
    {
        return $this->AdditionalInsurance;
    }
    /**
     * Set AdditionalInsurance value
     * @param \StructType\ServiceconfigurationAdditionalInsurance $additionalInsurance
     * @return \StructType\ShipmentService
     */
    public function setAdditionalInsurance(\StructType\ServiceconfigurationAdditionalInsurance $additionalInsurance = null)
    {
        $this->AdditionalInsurance = $additionalInsurance;
        return $this;
    }
    /**
     * Get BulkyGoods value
     * @return \StructType\Serviceconfiguration|null
     */
    public function getBulkyGoods()
    {
        return $this->BulkyGoods;
    }
    /**
     * Set BulkyGoods value
     * @param \StructType\Serviceconfiguration $bulkyGoods
     * @return \StructType\ShipmentService
     */
    public function setBulkyGoods(\StructType\Serviceconfiguration $bulkyGoods = null)
    {
        $this->BulkyGoods = $bulkyGoods;
        return $this;
    }
    /**
     * Get IdentCheck value
     * @return \StructType\ServiceconfigurationIC|null
     */
    public function getIdentCheck()
    {
        return $this->IdentCheck;
    }
    /**
     * Set IdentCheck value
     * @param \StructType\ServiceconfigurationIC $identCheck
     * @return \StructType\ShipmentService
     */
    public function setIdentCheck(\StructType\ServiceconfigurationIC $identCheck = null)
    {
        $this->IdentCheck = $identCheck;
        return $this;
    }
    /**
     * Get ParcelOutletRouting value
     * @return \StructType\ServiceconfigurationDetailsOptional|null
     */
    public function getParcelOutletRouting()
    {
        return $this->ParcelOutletRouting;
    }
    /**
     * Set ParcelOutletRouting value
     * @param \StructType\ServiceconfigurationDetailsOptional $parcelOutletRouting
     * @return \StructType\ShipmentService
     */
    public function setParcelOutletRouting(\StructType\ServiceconfigurationDetailsOptional $parcelOutletRouting = null)
    {
        $this->ParcelOutletRouting = $parcelOutletRouting;
        return $this;
    }
}
