<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentOrderType StructType
 * Meta information extracted from the WSDL
 * - documentation: Data for the creation of a shipment.
 * @subpackage Structs
 */
class ShipmentOrderType extends AbstractStructBase
{
    /**
     * The sequenceNumber
     * Meta information extracted from the WSDL
     * - documentation: Free field to to tag multiple shipment orders individually by client. Essential for later mapping of response data returned by webservice upon createShipment operation. Allows client to assign the shipment information of the response
     * to the correct shipment order of the request. | A sequence number defined by the (soap-) client. The sequenceNumber is returned by the webservice within the result of the createShipment operation, so that the client is able to assign the shipment
     * information of the response to the shipment data of the request.
     * - base: xs:string
     * - maxLength: 50
     * @var string
     */
    public $sequenceNumber;
    /**
     * The Shipment
     * @var \StructType\Shipment
     */
    public $Shipment;
    /**
     * The PrintOnlyIfCodeable
     * Meta information extracted from the WSDL
     * - documentation: If set to true (=1), the label will be only be printable, if the receiver address is valid.
     * - minOccurs: 0
     * @var \StructType\Serviceconfiguration
     */
    public $PrintOnlyIfCodeable;
    /**
     * Constructor method for ShipmentOrderType
     * @uses ShipmentOrderType::setSequenceNumber()
     * @uses ShipmentOrderType::setShipment()
     * @uses ShipmentOrderType::setPrintOnlyIfCodeable()
     * @param string $sequenceNumber
     * @param \StructType\Shipment $shipment
     * @param \StructType\Serviceconfiguration $printOnlyIfCodeable
     */
    public function __construct($sequenceNumber = null, \StructType\Shipment $shipment = null, \StructType\Serviceconfiguration $printOnlyIfCodeable = null)
    {
        $this
            ->setSequenceNumber($sequenceNumber)
            ->setShipment($shipment)
            ->setPrintOnlyIfCodeable($printOnlyIfCodeable);
    }
    /**
     * Get sequenceNumber value
     * @return string|null
     */
    public function getSequenceNumber()
    {
        return $this->sequenceNumber;
    }
    /**
     * Set sequenceNumber value
     * @param string $sequenceNumber
     * @return \StructType\ShipmentOrderType
     */
    public function setSequenceNumber($sequenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($sequenceNumber) && !is_string($sequenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sequenceNumber, true), gettype($sequenceNumber)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($sequenceNumber) && mb_strlen($sequenceNumber) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($sequenceNumber)), __LINE__);
        }
        $this->sequenceNumber = $sequenceNumber;
        return $this;
    }
    /**
     * Get Shipment value
     * @return \StructType\Shipment|null
     */
    public function getShipment()
    {
        return $this->Shipment;
    }
    /**
     * Set Shipment value
     * @param \StructType\Shipment $shipment
     * @return \StructType\ShipmentOrderType
     */
    public function setShipment(\StructType\Shipment $shipment = null)
    {
        $this->Shipment = $shipment;
        return $this;
    }
    /**
     * Get PrintOnlyIfCodeable value
     * @return \StructType\Serviceconfiguration|null
     */
    public function getPrintOnlyIfCodeable()
    {
        return $this->PrintOnlyIfCodeable;
    }
    /**
     * Set PrintOnlyIfCodeable value
     * @param \StructType\Serviceconfiguration $printOnlyIfCodeable
     * @return \StructType\ShipmentOrderType
     */
    public function setPrintOnlyIfCodeable(\StructType\Serviceconfiguration $printOnlyIfCodeable = null)
    {
        $this->PrintOnlyIfCodeable = $printOnlyIfCodeable;
        return $this;
    }
}
