<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Shipment StructType
 * Meta information extracted from the WSDL
 * - documentation: Is the core element of a ShipmentOrder. It contains all relevant information of the shipment.
 * @subpackage Structs
 */
class Shipment extends AbstractStructBase
{
    /**
     * The ShipmentDetails
     * Meta information extracted from the WSDL
     * - documentation: Contains the information of the shipment product code, weight and size characteristics and services to be used.
     * @var \StructType\ShipmentDetailsTypeType
     */
    public $ShipmentDetails;
    /**
     * The Shipper
     * Meta information extracted from the WSDL
     * - documentation: Contains relevant information about the Shipper.
     * - choice: Shipper | ShipperReference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\ShipperType
     */
    public $Shipper;
    /**
     * The ShipperReference
     * Meta information extracted from the WSDL
     * - documentation: Contains a reference to the Shipper data configured in GKP. | Key of reference.
     * - base: string
     * - choice: Shipper | ShipperReference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 50
     * @var string
     */
    public $ShipperReference;
    /**
     * The Receiver
     * Meta information extracted from the WSDL
     * - documentation: Contains relevant information about Receiver.
     * @var \StructType\ReceiverType
     */
    public $Receiver;
    /**
     * The ReturnReceiver
     * Meta information extracted from the WSDL
     * - documentation: To be used if a return label address shall be generated.
     * - minOccurs: 0
     * @var \StructType\ShipperType
     */
    public $ReturnReceiver;
    /**
     * The ExportDocument
     * Meta information extracted from the WSDL
     * - documentation: For international shipments. This section contains information about the exported goods relevant for customs. For international shipments: commercial invoice and customs declaration (CN23) have to be attached to the shipment. Data
     * relevant for customs also has to be transferred as electronically.
     * - minOccurs: 0
     * @var \StructType\ExportDocumentType
     */
    public $ExportDocument;
    /**
     * The feederSystem
     * Meta information extracted from the WSDL
     * - documentation: Is only to be indicated by DHL partners
     * - base: xs:string
     * - minOccurs: 0
     * @var string
     */
    public $feederSystem;
    /**
     * Constructor method for Shipment
     * @uses Shipment::setShipmentDetails()
     * @uses Shipment::setShipper()
     * @uses Shipment::setShipperReference()
     * @uses Shipment::setReceiver()
     * @uses Shipment::setReturnReceiver()
     * @uses Shipment::setExportDocument()
     * @uses Shipment::setFeederSystem()
     * @param \StructType\ShipmentDetailsTypeType $shipmentDetails
     * @param \StructType\ShipperType $shipper
     * @param string $shipperReference
     * @param \StructType\ReceiverType $receiver
     * @param \StructType\ShipperType $returnReceiver
     * @param \StructType\ExportDocumentType $exportDocument
     * @param string $feederSystem
     */
    public function __construct(\StructType\ShipmentDetailsTypeType $shipmentDetails = null, \StructType\ShipperType $shipper = null, $shipperReference = null, \StructType\ReceiverType $receiver = null, \StructType\ShipperType $returnReceiver = null, \StructType\ExportDocumentType $exportDocument = null, $feederSystem = null)
    {
        $this
            ->setShipmentDetails($shipmentDetails)
            ->setShipper($shipper)
            ->setShipperReference($shipperReference)
            ->setReceiver($receiver)
            ->setReturnReceiver($returnReceiver)
            ->setExportDocument($exportDocument)
            ->setFeederSystem($feederSystem);
    }
    /**
     * Get ShipmentDetails value
     * @return \StructType\ShipmentDetailsTypeType|null
     */
    public function getShipmentDetails()
    {
        return $this->ShipmentDetails;
    }
    /**
     * Set ShipmentDetails value
     * @param \StructType\ShipmentDetailsTypeType $shipmentDetails
     * @return \StructType\Shipment
     */
    public function setShipmentDetails(\StructType\ShipmentDetailsTypeType $shipmentDetails = null)
    {
        $this->ShipmentDetails = $shipmentDetails;
        return $this;
    }
    /**
     * Get Shipper value
     * @return \StructType\ShipperType|null
     */
    public function getShipper()
    {
        return isset($this->Shipper) ? $this->Shipper : null;
    }
    /**
     * This method is responsible for validating the value passed to the setShipper method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipper method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateShipperForChoiceConstraintsFromSetShipper($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ShipperReference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Shipper can\'t be set as the property %s is already set. Only one property must be set among these properties: Shipper, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Shipper value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ShipperType $shipper
     * @return \StructType\Shipment
     */
    public function setShipper(\StructType\ShipperType $shipper = null)
    {
        // validation for constraint: choice(Shipper, ShipperReference)
        if ('' !== ($shipperChoiceErrorMessage = self::validateShipperForChoiceConstraintsFromSetShipper($shipper))) {
            throw new \InvalidArgumentException($shipperChoiceErrorMessage, __LINE__);
        }
        if (is_null($shipper) || (is_array($shipper) && empty($shipper))) {
            unset($this->Shipper);
        } else {
            $this->Shipper = $shipper;
        }
        return $this;
    }
    /**
     * Get ShipperReference value
     * @return string|null
     */
    public function getShipperReference()
    {
        return isset($this->ShipperReference) ? $this->ShipperReference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setShipperReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipperReference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateShipperReferenceForChoiceConstraintsFromSetShipperReference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Shipper',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ShipperReference can\'t be set as the property %s is already set. Only one property must be set among these properties: ShipperReference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ShipperReference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $shipperReference
     * @return \StructType\Shipment
     */
    public function setShipperReference($shipperReference = null)
    {
        // validation for constraint: string
        if (!is_null($shipperReference) && !is_string($shipperReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipperReference, true), gettype($shipperReference)), __LINE__);
        }
        // validation for constraint: choice(Shipper, ShipperReference)
        if ('' !== ($shipperReferenceChoiceErrorMessage = self::validateShipperReferenceForChoiceConstraintsFromSetShipperReference($shipperReference))) {
            throw new \InvalidArgumentException($shipperReferenceChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($shipperReference) && mb_strlen($shipperReference) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($shipperReference)), __LINE__);
        }
        if (is_null($shipperReference) || (is_array($shipperReference) && empty($shipperReference))) {
            unset($this->ShipperReference);
        } else {
            $this->ShipperReference = $shipperReference;
        }
        return $this;
    }
    /**
     * Get Receiver value
     * @return \StructType\ReceiverType|null
     */
    public function getReceiver()
    {
        return $this->Receiver;
    }
    /**
     * Set Receiver value
     * @param \StructType\ReceiverType $receiver
     * @return \StructType\Shipment
     */
    public function setReceiver(\StructType\ReceiverType $receiver = null)
    {
        $this->Receiver = $receiver;
        return $this;
    }
    /**
     * Get ReturnReceiver value
     * @return \StructType\ShipperType|null
     */
    public function getReturnReceiver()
    {
        return $this->ReturnReceiver;
    }
    /**
     * Set ReturnReceiver value
     * @param \StructType\ShipperType $returnReceiver
     * @return \StructType\Shipment
     */
    public function setReturnReceiver(\StructType\ShipperType $returnReceiver = null)
    {
        $this->ReturnReceiver = $returnReceiver;
        return $this;
    }
    /**
     * Get ExportDocument value
     * @return \StructType\ExportDocumentType|null
     */
    public function getExportDocument()
    {
        return $this->ExportDocument;
    }
    /**
     * Set ExportDocument value
     * @param \StructType\ExportDocumentType $exportDocument
     * @return \StructType\Shipment
     */
    public function setExportDocument(\StructType\ExportDocumentType $exportDocument = null)
    {
        $this->ExportDocument = $exportDocument;
        return $this;
    }
    /**
     * Get feederSystem value
     * @return string|null
     */
    public function getFeederSystem()
    {
        return $this->feederSystem;
    }
    /**
     * Set feederSystem value
     * @param string $feederSystem
     * @return \StructType\Shipment
     */
    public function setFeederSystem($feederSystem = null)
    {
        // validation for constraint: string
        if (!is_null($feederSystem) && !is_string($feederSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feederSystem, true), gettype($feederSystem)), __LINE__);
        }
        $this->feederSystem = $feederSystem;
        return $this;
    }
}
