<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceconfigurationDetailsPreferredNeighbour StructType
 * @subpackage Structs
 */
class ServiceconfigurationDetailsPreferredNeighbour extends AbstractStructBase
{
    /**
     * The active
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $active;
    /**
     * The details
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 100
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $details;
    /**
     * Constructor method for ServiceconfigurationDetailsPreferredNeighbour
     * @uses ServiceconfigurationDetailsPreferredNeighbour::setActive()
     * @uses ServiceconfigurationDetailsPreferredNeighbour::setDetails()
     * @param string $active
     * @param string $details
     */
    public function __construct($active = null, $details = null)
    {
        $this
            ->setActive($active)
            ->setDetails($details);
    }
    /**
     * Get active value
     * @return string
     */
    public function getActive()
    {
        return $this->active;
    }
    /**
     * Set active value
     * @param string $active
     * @return \StructType\ServiceconfigurationDetailsPreferredNeighbour
     */
    public function setActive($active = null)
    {
        // validation for constraint: string
        if (!is_null($active) && !is_string($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->active = $active;
        return $this;
    }
    /**
     * Get details value
     * @return string
     */
    public function getDetails()
    {
        return $this->details;
    }
    /**
     * Set details value
     * @param string $details
     * @return \StructType\ServiceconfigurationDetailsPreferredNeighbour
     */
    public function setDetails($details = null)
    {
        // validation for constraint: string
        if (!is_null($details) && !is_string($details)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($details, true), gettype($details)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($details) && mb_strlen($details) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($details)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($details) && mb_strlen($details) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($details)), __LINE__);
        }
        $this->details = $details;
        return $this;
    }
}
