<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceconfigurationDH StructType
 * @subpackage Structs
 */
class ServiceconfigurationDH extends AbstractStructBase
{
    /**
     * The active
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $active;
    /**
     * The Days
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 1
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $Days;
    /**
     * Constructor method for ServiceconfigurationDH
     * @uses ServiceconfigurationDH::setActive()
     * @uses ServiceconfigurationDH::setDays()
     * @param string $active
     * @param string $days
     */
    public function __construct($active = null, $days = null)
    {
        $this
            ->setActive($active)
            ->setDays($days);
    }
    /**
     * Get active value
     * @return string
     */
    public function getActive()
    {
        return $this->active;
    }
    /**
     * Set active value
     * @param string $active
     * @return \StructType\ServiceconfigurationDH
     */
    public function setActive($active = null)
    {
        // validation for constraint: string
        if (!is_null($active) && !is_string($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->active = $active;
        return $this;
    }
    /**
     * Get Days value
     * @return string
     */
    public function getDays()
    {
        return $this->Days;
    }
    /**
     * Set Days value
     * @param string $days
     * @return \StructType\ServiceconfigurationDH
     */
    public function setDays($days = null)
    {
        // validation for constraint: string
        if (!is_null($days) && !is_string($days)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($days, true), gettype($days)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($days) && mb_strlen($days) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($days)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($days) && mb_strlen($days) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($days)), __LINE__);
        }
        $this->Days = $days;
        return $this;
    }
}
