<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReadShipmentOrderResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: The version of the webservice implementation. | The status of the operation and the shipment identifier (if available).
 * @subpackage Structs
 */
class ReadShipmentOrderResponse extends AbstractStructBase
{
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - ref: bcs:Version
     * @var \StructType\Version
     */
    public $Version;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - documentation: Success status after processing the overall request.
     * @var \StructType\Statusinformation
     */
    public $status;
    /**
     * The CreationState
     * Meta information extracted from the WSDL
     * - documentation: The operation's success status for every single ShipmentOrder will be returned by one CreationState element. It is identifiable via SequenceNumber.
     * - maxOccurs: 30
     * - minOccurs: 0
     * @var \StructType\CreationState[]
     */
    public $CreationState;
    /**
     * Constructor method for ReadShipmentOrderResponse
     * @uses ReadShipmentOrderResponse::setVersion()
     * @uses ReadShipmentOrderResponse::setStatus()
     * @uses ReadShipmentOrderResponse::setCreationState()
     * @param \StructType\Version $version
     * @param \StructType\Statusinformation $status
     * @param \StructType\CreationState[] $creationState
     */
    public function __construct(\StructType\Version $version = null, \StructType\Statusinformation $status = null, array $creationState = array())
    {
        $this
            ->setVersion($version)
            ->setStatus($status)
            ->setCreationState($creationState);
    }
    /**
     * Get Version value
     * @return \StructType\Version|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param \StructType\Version $version
     * @return \StructType\ReadShipmentOrderResponse
     */
    public function setVersion(\StructType\Version $version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get status value
     * @return \StructType\Statusinformation|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param \StructType\Statusinformation $status
     * @return \StructType\ReadShipmentOrderResponse
     */
    public function setStatus(\StructType\Statusinformation $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get CreationState value
     * @return \StructType\CreationState[]|null
     */
    public function getCreationState()
    {
        return $this->CreationState;
    }
    /**
     * This method is responsible for validating the values passed to the setCreationState method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCreationState method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCreationStateForArrayConstraintsFromSetCreationState(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $readShipmentOrderResponseCreationStateItem) {
            // validation for constraint: itemType
            if (!$readShipmentOrderResponseCreationStateItem instanceof \StructType\CreationState) {
                $invalidValues[] = is_object($readShipmentOrderResponseCreationStateItem) ? get_class($readShipmentOrderResponseCreationStateItem) : sprintf('%s(%s)', gettype($readShipmentOrderResponseCreationStateItem), var_export($readShipmentOrderResponseCreationStateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CreationState property can only contain items of type \StructType\CreationState, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CreationState value
     * @throws \InvalidArgumentException
     * @param \StructType\CreationState[] $creationState
     * @return \StructType\ReadShipmentOrderResponse
     */
    public function setCreationState(array $creationState = array())
    {
        // validation for constraint: array
        if ('' !== ($creationStateArrayErrorMessage = self::validateCreationStateForArrayConstraintsFromSetCreationState($creationState))) {
            throw new \InvalidArgumentException($creationStateArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($creationState) && count($creationState) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 30', count($creationState)), __LINE__);
        }
        $this->CreationState = $creationState;
        return $this;
    }
    /**
     * Add item to CreationState value
     * @throws \InvalidArgumentException
     * @param \StructType\CreationState $item
     * @return \StructType\ReadShipmentOrderResponse
     */
    public function addToCreationState(\StructType\CreationState $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CreationState) {
            throw new \InvalidArgumentException(sprintf('The CreationState property can only contain items of type \StructType\CreationState, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($this->CreationState) && count($this->CreationState) >= 30) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 30', count($this->CreationState)), __LINE__);
        }
        $this->CreationState[] = $item;
        return $this;
    }
}
