<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PostfilialeType StructType
 * Meta information extracted from the WSDL
 * - documentation: includes | Type of Postfiliale (Receiver is in Germany) | Type of Postfiliale
 * @subpackage Structs
 */
class PostfilialeType extends AbstractStructBase
{
    /**
     * The postfilialNumber
     * Meta information extracted from the WSDL
     * - documentation: Number of the postfiliale
     * - base: xs:string
     * - maxLength: 3
     * - minLength: 3
     * @var string
     */
    public $postfilialNumber;
    /**
     * The postNumber
     * Meta information extracted from the WSDL
     * - documentation: Post Nummer of the receiver, if not set receiver e-mail and/or mobilephone number needs to be set. When sending to a packstation with "DHL Paket" (V01PAK), the postnumber must always be entered. | Post Nummer of the receiver | Post
     * Nummer of the receiver or receiver e-mail-adress.
     * - base: xs:string
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $postNumber;
    /**
     * The zip
     * Meta information extracted from the WSDL
     * - documentation: Type of zip code
     * - base: xs:string
     * - maxLength: 17
     * - ref: cis:zip
     * @var string
     */
    public $zip;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - documentation: City name.
     * - base: xs:string
     * - maxLength: 50
     * - ref: cis:city
     * @var string
     */
    public $city;
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: cis:Origin
     * @var \StructType\CountryType
     */
    public $Origin;
    /**
     * The PostfilialNumber
     * Meta information extracted from the WSDL
     * - documentation: Number of the postfiliale
     * @var string
     */
    public $PostfilialNumber;
    /**
     * The PostNumber
     * Meta information extracted from the WSDL
     * - documentation: Post Nummer of the receiver
     * @var string
     */
    public $PostNumber;
    /**
     * The Zip
     * Meta information extracted from the WSDL
     * - documentation: Postcode
     * - base: xs:string
     * - maxLength: 5
     * - minLength: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $Zip;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - documentation: City name.
     * - base: xs:string
     * - maxLength: 50
     * @var string
     */
    public $City;
    /**
     * Constructor method for PostfilialeType
     * @uses PostfilialeType::setPostfilialNumber()
     * @uses PostfilialeType::setPostNumber()
     * @uses PostfilialeType::setZip()
     * @uses PostfilialeType::setCity()
     * @uses PostfilialeType::setOrigin()
     * @uses PostfilialeType::setPostfilialNumber_1()
     * @uses PostfilialeType::setPostNumber_1()
     * @uses PostfilialeType::setZip_1()
     * @uses PostfilialeType::setCity_1()
     * @param string $postfilialNumber
     * @param string $postNumber
     * @param string $zip
     * @param string $city
     * @param \StructType\CountryType $origin
     * @param string $postfilialNumber
     * @param string $postNumber
     * @param string $zip
     * @param string $city
     */
    public function __construct($postfilialNumber = null, $postNumber = null, $zip = null, $city = null, \StructType\CountryType $origin = null, $postfilialNumber_1 = null, $postNumber_1 = null, $zip_1 = null, $city_1 = null)
    {
        $this
            ->setPostfilialNumber($postfilialNumber)
            ->setPostNumber($postNumber)
            ->setZip($zip)
            ->setCity($city)
            ->setOrigin($origin)
            ->setPostfilialNumber_1($postfilialNumber_1)
            ->setPostNumber_1($postNumber_1)
            ->setZip_1($zip_1)
            ->setCity_1($city_1);
    }
    /**
     * Get PostfilialNumber value
     * @return string|null
     */
    public function getPostfilialNumber()
    {
        return $this->postfilialNumber;
    }
    /**
     * Set PostfilialNumber value
     * @param string $postfilialNumber
     * @return \StructType\PostfilialeType
     */
    public function setPostfilialNumber($postfilialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($postfilialNumber) && !is_string($postfilialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postfilialNumber, true), gettype($postfilialNumber)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($postfilialNumber) && mb_strlen($postfilialNumber) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($postfilialNumber)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($postfilialNumber) && mb_strlen($postfilialNumber) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($postfilialNumber)), __LINE__);
        }
        $this->postfilialNumber = $postfilialNumber;
        return $this;
    }
    /**
     * Get PostNumber value
     * @return string|null
     */
    public function getPostNumber()
    {
        return $this->postNumber;
    }
    /**
     * Set PostNumber value
     * @param string $postNumber
     * @return \StructType\PostfilialeType
     */
    public function setPostNumber($postNumber = null)
    {
        // validation for constraint: string
        if (!is_null($postNumber) && !is_string($postNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postNumber, true), gettype($postNumber)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($postNumber) && mb_strlen($postNumber) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($postNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($postNumber) && mb_strlen($postNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($postNumber)), __LINE__);
        }
        $this->postNumber = $postNumber;
        return $this;
    }
    /**
     * Get Zip value
     * @return string|null
     */
    public function getZip()
    {
        return $this->zip;
    }
    /**
     * Set Zip value
     * @param string $zip
     * @return \StructType\PostfilialeType
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zip, true), gettype($zip)), __LINE__);
        }
        // validation for constraint: maxLength(17)
        if (!is_null($zip) && mb_strlen($zip) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 17', mb_strlen($zip)), __LINE__);
        }
        $this->zip = $zip;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\PostfilialeType
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($city) && mb_strlen($city) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get Origin value
     * @return \StructType\CountryType|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param \StructType\CountryType $origin
     * @return \StructType\PostfilialeType
     */
    public function setOrigin(\StructType\CountryType $origin = null)
    {
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get PostfilialNumber value
     * @return string|null
     */
    public function getPostfilialNumber_1()
    {
        return $this->PostfilialNumber;
    }
    /**
     * Set PostfilialNumber value
     * @param string $postfilialNumber
     * @return \StructType\PostfilialeType
     */
    public function setPostfilialNumber_1($postfilialNumber_1 = null)
    {
        // validation for constraint: string
        if (!is_null($postfilialNumber_1) && !is_string($postfilialNumber_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postfilialNumber_1, true), gettype($postfilialNumber_1)), __LINE__);
        }
        $this->PostfilialNumber = $postfilialNumber_1;
        return $this;
    }
    /**
     * Get PostNumber value
     * @return string|null
     */
    public function getPostNumber_1()
    {
        return $this->PostNumber;
    }
    /**
     * Set PostNumber value
     * @param string $postNumber
     * @return \StructType\PostfilialeType
     */
    public function setPostNumber_1($postNumber_1 = null)
    {
        // validation for constraint: string
        if (!is_null($postNumber_1) && !is_string($postNumber_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postNumber_1, true), gettype($postNumber_1)), __LINE__);
        }
        $this->PostNumber = $postNumber_1;
        return $this;
    }
    /**
     * Get Zip value
     * @return string|null
     */
    public function getZip_1()
    {
        return $this->Zip;
    }
    /**
     * Set Zip value
     * @param string $zip
     * @return \StructType\PostfilialeType
     */
    public function setZip_1($zip_1 = null)
    {
        // validation for constraint: string
        if (!is_null($zip_1) && !is_string($zip_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zip_1, true), gettype($zip_1)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($zip_1) && mb_strlen($zip_1) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($zip_1)), __LINE__);
        }
        // validation for constraint: minLength(5)
        if (!is_null($zip_1) && mb_strlen($zip_1) < 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 5', mb_strlen($zip_1)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{5})
        if (!is_null($zip_1) && !preg_match('/[0-9]{5}/', $zip_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{5}', var_export($zip_1, true)), __LINE__);
        }
        $this->Zip = $zip_1;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity_1()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\PostfilialeType
     */
    public function setCity_1($city_1 = null)
    {
        // validation for constraint: string
        if (!is_null($city_1) && !is_string($city_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city_1, true), gettype($city_1)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($city_1) && mb_strlen($city_1) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($city_1)), __LINE__);
        }
        $this->City = $city_1;
        return $this;
    }
}
