<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PickupAddressType StructType
 * Meta information extracted from the WSDL
 * - documentation: The pickup address. In the PickupType the following data fields are processed/mandatory/optional:----------------------------------------------------------------------------------------------Company Name 1 (mandatory):
 * cis:NameType->Company->name1Contact Name (mandatory): cis:CommunicationType->contactPersonStreet Name (mandatory): cis:NativeAddressType->streetNameStreet Number (mandatory): cis:NativeAddressType->streetNumberAdd. Address (optional) :
 * cis:NativeAddressType->careOfNamePostcode (mandatory): cis:NativeAddressType->zipCity Name (mandatory): cis:NativeAddressType->cityISO Country Code (mandatory): cis:NativeAddressType->Origin->CountryType->countryISOTypePhone Number (mandatory):
 * cis:CommunicationType->phoneEmail Address (mandatory): cis:CommunicationType->email | can be | includes | Type of pickup address
 * @subpackage Structs
 */
class PickupAddressType extends AbstractStructBase
{
    /**
     * The NativeAddress
     * Meta information extracted from the WSDL
     * - documentation: Default address
     * - choice: NativeAddress | PackStation
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\NativeAddressType
     */
    public $NativeAddress;
    /**
     * The PackStation
     * Meta information extracted from the WSDL
     * - documentation: Packstation address
     * - choice: NativeAddress | PackStation
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\PackStationType
     */
    public $PackStation;
    /**
     * The streetNameCode
     * Meta information extracted from the WSDL
     * - documentation: Code for street name (part of routecode).
     * - base: xs:string
     * - maxLength: 3
     * - minLength: 3
     * - minOccurs: 0
     * - ref: cis:streetNameCode
     * @var string
     */
    public $streetNameCode;
    /**
     * The streetNumberCode
     * Meta information extracted from the WSDL
     * - documentation: Code for street number (part of routecode).
     * - base: xs:string
     * - maxLength: 3
     * - minLength: 3
     * - minOccurs: 0
     * - ref: cis:streetNumberCode
     * @var string
     */
    public $streetNumberCode;
    /**
     * The Company
     * Meta information extracted from the WSDL
     * - documentation: Determines whether pickup address is one of the following types.
     * @var \StructType\NameType
     */
    public $Company;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - documentation: Data fields for pickup address.
     * @var \StructType\NativeAddressType
     */
    public $Address;
    /**
     * The Communication
     * Meta information extracted from the WSDL
     * - documentation: Info about communication.
     * @var \StructType\CommunicationType
     */
    public $Communication;
    /**
     * Constructor method for PickupAddressType
     * @uses PickupAddressType::setNativeAddress()
     * @uses PickupAddressType::setPackStation()
     * @uses PickupAddressType::setStreetNameCode()
     * @uses PickupAddressType::setStreetNumberCode()
     * @uses PickupAddressType::setCompany()
     * @uses PickupAddressType::setAddress()
     * @uses PickupAddressType::setCommunication()
     * @param \StructType\NativeAddressType $nativeAddress
     * @param \StructType\PackStationType $packStation
     * @param string $streetNameCode
     * @param string $streetNumberCode
     * @param \StructType\NameType $company
     * @param \StructType\NativeAddressType $address
     * @param \StructType\CommunicationType $communication
     */
    public function __construct(\StructType\NativeAddressType $nativeAddress = null, \StructType\PackStationType $packStation = null, $streetNameCode = null, $streetNumberCode = null, \StructType\NameType $company = null, \StructType\NativeAddressType $address = null, \StructType\CommunicationType $communication = null)
    {
        $this
            ->setNativeAddress($nativeAddress)
            ->setPackStation($packStation)
            ->setStreetNameCode($streetNameCode)
            ->setStreetNumberCode($streetNumberCode)
            ->setCompany($company)
            ->setAddress($address)
            ->setCommunication($communication);
    }
    /**
     * Get NativeAddress value
     * @return \StructType\NativeAddressType|null
     */
    public function getNativeAddress()
    {
        return isset($this->NativeAddress) ? $this->NativeAddress : null;
    }
    /**
     * This method is responsible for validating the value passed to the setNativeAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNativeAddress method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateNativeAddressForChoiceConstraintsFromSetNativeAddress($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'PackStation',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property NativeAddress can\'t be set as the property %s is already set. Only one property must be set among these properties: NativeAddress, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set NativeAddress value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\NativeAddressType $nativeAddress
     * @return \StructType\PickupAddressType
     */
    public function setNativeAddress(\StructType\NativeAddressType $nativeAddress = null)
    {
        // validation for constraint: choice(NativeAddress, PackStation)
        if ('' !== ($nativeAddressChoiceErrorMessage = self::validateNativeAddressForChoiceConstraintsFromSetNativeAddress($nativeAddress))) {
            throw new \InvalidArgumentException($nativeAddressChoiceErrorMessage, __LINE__);
        }
        if (is_null($nativeAddress) || (is_array($nativeAddress) && empty($nativeAddress))) {
            unset($this->NativeAddress);
        } else {
            $this->NativeAddress = $nativeAddress;
        }
        return $this;
    }
    /**
     * Get PackStation value
     * @return \StructType\PackStationType|null
     */
    public function getPackStation()
    {
        return isset($this->PackStation) ? $this->PackStation : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPackStation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackStation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePackStationForChoiceConstraintsFromSetPackStation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'NativeAddress',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PackStation can\'t be set as the property %s is already set. Only one property must be set among these properties: PackStation, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PackStation value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PackStationType $packStation
     * @return \StructType\PickupAddressType
     */
    public function setPackStation(\StructType\PackStationType $packStation = null)
    {
        // validation for constraint: choice(NativeAddress, PackStation)
        if ('' !== ($packStationChoiceErrorMessage = self::validatePackStationForChoiceConstraintsFromSetPackStation($packStation))) {
            throw new \InvalidArgumentException($packStationChoiceErrorMessage, __LINE__);
        }
        if (is_null($packStation) || (is_array($packStation) && empty($packStation))) {
            unset($this->PackStation);
        } else {
            $this->PackStation = $packStation;
        }
        return $this;
    }
    /**
     * Get streetNameCode value
     * @return string|null
     */
    public function getStreetNameCode()
    {
        return $this->streetNameCode;
    }
    /**
     * Set streetNameCode value
     * @param string $streetNameCode
     * @return \StructType\PickupAddressType
     */
    public function setStreetNameCode($streetNameCode = null)
    {
        // validation for constraint: string
        if (!is_null($streetNameCode) && !is_string($streetNameCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetNameCode, true), gettype($streetNameCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($streetNameCode) && mb_strlen($streetNameCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($streetNameCode)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($streetNameCode) && mb_strlen($streetNameCode) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($streetNameCode)), __LINE__);
        }
        $this->streetNameCode = $streetNameCode;
        return $this;
    }
    /**
     * Get streetNumberCode value
     * @return string|null
     */
    public function getStreetNumberCode()
    {
        return $this->streetNumberCode;
    }
    /**
     * Set streetNumberCode value
     * @param string $streetNumberCode
     * @return \StructType\PickupAddressType
     */
    public function setStreetNumberCode($streetNumberCode = null)
    {
        // validation for constraint: string
        if (!is_null($streetNumberCode) && !is_string($streetNumberCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetNumberCode, true), gettype($streetNumberCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($streetNumberCode) && mb_strlen($streetNumberCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($streetNumberCode)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($streetNumberCode) && mb_strlen($streetNumberCode) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($streetNumberCode)), __LINE__);
        }
        $this->streetNumberCode = $streetNumberCode;
        return $this;
    }
    /**
     * Get Company value
     * @return \StructType\NameType|null
     */
    public function getCompany()
    {
        return $this->Company;
    }
    /**
     * Set Company value
     * @param \StructType\NameType $company
     * @return \StructType\PickupAddressType
     */
    public function setCompany(\StructType\NameType $company = null)
    {
        $this->Company = $company;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\NativeAddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\NativeAddressType $address
     * @return \StructType\PickupAddressType
     */
    public function setAddress(\StructType\NativeAddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Communication value
     * @return \StructType\CommunicationType|null
     */
    public function getCommunication()
    {
        return $this->Communication;
    }
    /**
     * Set Communication value
     * @param \StructType\CommunicationType $communication
     * @return \StructType\PickupAddressType
     */
    public function setCommunication(\StructType\CommunicationType $communication = null)
    {
        $this->Communication = $communication;
        return $this;
    }
}
