<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackstationType StructType
 * Meta information extracted from the WSDL
 * - documentation: includes | Type of Packstation (Receiver is in Germany)
 * @subpackage Structs
 */
class PackstationType_1 extends AbstractStructBase
{
    /**
     * The PackstationNumber
     * Meta information extracted from the WSDL
     * - documentation: Number of the packstation
     * @var string
     */
    public $PackstationNumber;
    /**
     * The PostNumber
     * Meta information extracted from the WSDL
     * - documentation: Post Nummer of the receiver
     * @var string
     */
    public $PostNumber;
    /**
     * The Zip
     * Meta information extracted from the WSDL
     * - documentation: Postcode
     * - base: xs:string
     * - maxLength: 5
     * - minLength: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $Zip;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - documentation: City name.
     * - base: xs:string
     * - maxLength: 50
     * @var string
     */
    public $City;
    /**
     * Constructor method for PackstationType
     * @uses PackstationType_1::setPackstationNumber()
     * @uses PackstationType_1::setPostNumber()
     * @uses PackstationType_1::setZip()
     * @uses PackstationType_1::setCity()
     * @param string $packstationNumber
     * @param string $postNumber
     * @param string $zip
     * @param string $city
     */
    public function __construct($packstationNumber = null, $postNumber = null, $zip = null, $city = null)
    {
        $this
            ->setPackstationNumber($packstationNumber)
            ->setPostNumber($postNumber)
            ->setZip($zip)
            ->setCity($city);
    }
    /**
     * Get PackstationNumber value
     * @return string|null
     */
    public function getPackstationNumber()
    {
        return $this->PackstationNumber;
    }
    /**
     * Set PackstationNumber value
     * @param string $packstationNumber
     * @return \StructType\PackstationType_1
     */
    public function setPackstationNumber($packstationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($packstationNumber) && !is_string($packstationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packstationNumber, true), gettype($packstationNumber)), __LINE__);
        }
        $this->PackstationNumber = $packstationNumber;
        return $this;
    }
    /**
     * Get PostNumber value
     * @return string|null
     */
    public function getPostNumber()
    {
        return $this->PostNumber;
    }
    /**
     * Set PostNumber value
     * @param string $postNumber
     * @return \StructType\PackstationType_1
     */
    public function setPostNumber($postNumber = null)
    {
        // validation for constraint: string
        if (!is_null($postNumber) && !is_string($postNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postNumber, true), gettype($postNumber)), __LINE__);
        }
        $this->PostNumber = $postNumber;
        return $this;
    }
    /**
     * Get Zip value
     * @return string|null
     */
    public function getZip()
    {
        return $this->Zip;
    }
    /**
     * Set Zip value
     * @param string $zip
     * @return \StructType\PackstationType_1
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zip, true), gettype($zip)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($zip) && mb_strlen($zip) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($zip)), __LINE__);
        }
        // validation for constraint: minLength(5)
        if (!is_null($zip) && mb_strlen($zip) < 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 5', mb_strlen($zip)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{5})
        if (!is_null($zip) && !preg_match('/[0-9]{5}/', $zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{5}', var_export($zip, true)), __LINE__);
        }
        $this->Zip = $zip;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\PackstationType_1
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($city) && mb_strlen($city) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
}
