<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NativeAddressTypeNew StructType
 * Meta information extracted from the WSDL
 * - documentation: includes | Type of native address
 * @subpackage Structs
 */
class NativeAddressTypeNew extends AbstractStructBase
{
    /**
     * The streetName
     * Meta information extracted from the WSDL
     * - documentation: The name of the street. Optionally the house number can be passed in this field too. In this case the field "streetNumber" must not be present. | Name of street of the ParcelShop
     * - base: xs:string
     * - maxLength: 50
     * @var string
     */
    public $streetName;
    /**
     * The streetNumber
     * Meta information extracted from the WSDL
     * - documentation: The house number. This field is only optional when the house number is passed with the field streetName. | House number of the ParcelShop
     * - base: xs:string
     * - maxLength: 10
     * - minOccurs: 0
     * @var string
     */
    public $streetNumber;
    /**
     * The zip
     * Meta information extracted from the WSDL
     * - documentation: Type of zip code
     * - base: xs:string
     * - maxLength: 17
     * - ref: cis:zip
     * @var string
     */
    public $zip;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - documentation: City name.
     * - base: xs:string
     * - maxLength: 50
     * - ref: cis:city
     * @var string
     */
    public $city;
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - documentation: Country.
     * - minOccurs: 0
     * @var \StructType\CountryType
     */
    public $Origin;
    /**
     * Constructor method for NativeAddressTypeNew
     * @uses NativeAddressTypeNew::setStreetName()
     * @uses NativeAddressTypeNew::setStreetNumber()
     * @uses NativeAddressTypeNew::setZip()
     * @uses NativeAddressTypeNew::setCity()
     * @uses NativeAddressTypeNew::setOrigin()
     * @param string $streetName
     * @param string $streetNumber
     * @param string $zip
     * @param string $city
     * @param \StructType\CountryType $origin
     */
    public function __construct($streetName = null, $streetNumber = null, $zip = null, $city = null, \StructType\CountryType $origin = null)
    {
        $this
            ->setStreetName($streetName)
            ->setStreetNumber($streetNumber)
            ->setZip($zip)
            ->setCity($city)
            ->setOrigin($origin);
    }
    /**
     * Get streetName value
     * @return string|null
     */
    public function getStreetName()
    {
        return $this->streetName;
    }
    /**
     * Set streetName value
     * @param string $streetName
     * @return \StructType\NativeAddressTypeNew
     */
    public function setStreetName($streetName = null)
    {
        // validation for constraint: string
        if (!is_null($streetName) && !is_string($streetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetName, true), gettype($streetName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($streetName) && mb_strlen($streetName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($streetName)), __LINE__);
        }
        $this->streetName = $streetName;
        return $this;
    }
    /**
     * Get streetNumber value
     * @return string|null
     */
    public function getStreetNumber()
    {
        return $this->streetNumber;
    }
    /**
     * Set streetNumber value
     * @param string $streetNumber
     * @return \StructType\NativeAddressTypeNew
     */
    public function setStreetNumber($streetNumber = null)
    {
        // validation for constraint: string
        if (!is_null($streetNumber) && !is_string($streetNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetNumber, true), gettype($streetNumber)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($streetNumber) && mb_strlen($streetNumber) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($streetNumber)), __LINE__);
        }
        $this->streetNumber = $streetNumber;
        return $this;
    }
    /**
     * Get zip value
     * @return string|null
     */
    public function getZip()
    {
        return $this->zip;
    }
    /**
     * Set zip value
     * @param string $zip
     * @return \StructType\NativeAddressTypeNew
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zip, true), gettype($zip)), __LINE__);
        }
        // validation for constraint: maxLength(17)
        if (!is_null($zip) && mb_strlen($zip) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 17', mb_strlen($zip)), __LINE__);
        }
        $this->zip = $zip;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\NativeAddressTypeNew
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($city) && mb_strlen($city) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get Origin value
     * @return \StructType\CountryType|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param \StructType\CountryType $origin
     * @return \StructType\NativeAddressTypeNew
     */
    public function setOrigin(\StructType\CountryType $origin = null)
    {
        $this->Origin = $origin;
        return $this;
    }
}
