<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NativeAddressType StructType
 * Meta information extracted from the WSDL
 * - documentation: includes | Type of native address
 * @subpackage Structs
 */
class NativeAddressType extends AbstractStructBase
{
    /**
     * The streetName
     * Meta information extracted from the WSDL
     * - documentation: The name of the street. Optionally the house number can be passed in this field too. In this case the field "streetNumber" must not be present. | Name of street of the ParcelShop
     * - base: xs:string
     * - maxLength: 50
     * @var string
     */
    public $streetName;
    /**
     * The streetNumber
     * Meta information extracted from the WSDL
     * - documentation: The house number. This field is only optional when the house number is passed with the field streetName. | House number of the ParcelShop
     * - base: xs:string
     * - maxLength: 10
     * - minOccurs: 0
     * @var string
     */
    public $streetNumber;
    /**
     * The addressAddition
     * Meta information extracted from the WSDL
     * - documentation: Address addon, is only printed in the international area (V53WPAK)
     * - base: xs:string
     * - maxLength: 35
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var string[]
     */
    public $addressAddition;
    /**
     * The dispatchingInformation
     * Meta information extracted from the WSDL
     * - documentation: DispatchingInformation, is only printed in the international area (V53WPAK)
     * - base: xs:string
     * - maxLength: 35
     * - minOccurs: 0
     * @var string
     */
    public $dispatchingInformation;
    /**
     * The zip
     * Meta information extracted from the WSDL
     * - documentation: Type of zip code
     * - base: xs:string
     * - maxLength: 17
     * - ref: cis:zip
     * @var string
     */
    public $zip;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - documentation: City name.
     * - base: xs:string
     * - maxLength: 50
     * - ref: cis:city
     * @var string
     */
    public $city;
    /**
     * The province
     * Meta information extracted from the WSDL
     * - documentation: Province name.
     * - base: xs:string
     * - maxLength: 35
     * - minOccurs: 0
     * - ref: cis:province
     * @var string
     */
    public $province;
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: cis:Origin
     * @var \StructType\CountryType
     */
    public $Origin;
    /**
     * Constructor method for NativeAddressType
     * @uses NativeAddressType::setStreetName()
     * @uses NativeAddressType::setStreetNumber()
     * @uses NativeAddressType::setAddressAddition()
     * @uses NativeAddressType::setDispatchingInformation()
     * @uses NativeAddressType::setZip()
     * @uses NativeAddressType::setCity()
     * @uses NativeAddressType::setProvince()
     * @uses NativeAddressType::setOrigin()
     * @param string $streetName
     * @param string $streetNumber
     * @param string[] $addressAddition
     * @param string $dispatchingInformation
     * @param string $zip
     * @param string $city
     * @param string $province
     * @param \StructType\CountryType $origin
     */
    public function __construct($streetName = null, $streetNumber = null, array $addressAddition = array(), $dispatchingInformation = null, $zip = null, $city = null, $province = null, \StructType\CountryType $origin = null)
    {
        $this
            ->setStreetName($streetName)
            ->setStreetNumber($streetNumber)
            ->setAddressAddition($addressAddition)
            ->setDispatchingInformation($dispatchingInformation)
            ->setZip($zip)
            ->setCity($city)
            ->setProvince($province)
            ->setOrigin($origin);
    }
    /**
     * Get streetName value
     * @return string|null
     */
    public function getStreetName()
    {
        return $this->streetName;
    }
    /**
     * Set streetName value
     * @param string $streetName
     * @return \StructType\NativeAddressType
     */
    public function setStreetName($streetName = null)
    {
        // validation for constraint: string
        if (!is_null($streetName) && !is_string($streetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetName, true), gettype($streetName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($streetName) && mb_strlen($streetName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($streetName)), __LINE__);
        }
        $this->streetName = $streetName;
        return $this;
    }
    /**
     * Get streetNumber value
     * @return string|null
     */
    public function getStreetNumber()
    {
        return $this->streetNumber;
    }
    /**
     * Set streetNumber value
     * @param string $streetNumber
     * @return \StructType\NativeAddressType
     */
    public function setStreetNumber($streetNumber = null)
    {
        // validation for constraint: string
        if (!is_null($streetNumber) && !is_string($streetNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetNumber, true), gettype($streetNumber)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($streetNumber) && mb_strlen($streetNumber) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($streetNumber)), __LINE__);
        }
        $this->streetNumber = $streetNumber;
        return $this;
    }
    /**
     * Get addressAddition value
     * @return string[]|null
     */
    public function getAddressAddition()
    {
        return $this->addressAddition;
    }
    /**
     * This method is responsible for validating the values passed to the setAddressAddition method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddressAddition method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressAdditionForArrayConstraintsFromSetAddressAddition(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $nativeAddressTypeAddressAdditionItem) {
            // validation for constraint: itemType
            if (!is_string($nativeAddressTypeAddressAdditionItem)) {
                $invalidValues[] = is_object($nativeAddressTypeAddressAdditionItem) ? get_class($nativeAddressTypeAddressAdditionItem) : sprintf('%s(%s)', gettype($nativeAddressTypeAddressAdditionItem), var_export($nativeAddressTypeAddressAdditionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The addressAddition property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setAddressAddition method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddressAddition method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressAdditionForMaxLengthConstraintFromSetAddressAddition($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $nativeAddressTypeAddressAdditionItem) {
            // validation for constraint: maxLength(35)
            if (mb_strlen($nativeAddressTypeAddressAdditionItem) > 35) {
                $invalidValues[] = var_export($nativeAddressTypeAddressAdditionItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 35', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set addressAddition value
     * @throws \InvalidArgumentException
     * @param string[] $addressAddition
     * @return \StructType\NativeAddressType
     */
    public function setAddressAddition(array $addressAddition = array())
    {
        // validation for constraint: array
        if ('' !== ($addressAdditionArrayErrorMessage = self::validateAddressAdditionForArrayConstraintsFromSetAddressAddition($addressAddition))) {
            throw new \InvalidArgumentException($addressAdditionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(35)
        if ('' !== ($addressAdditionMaxLengthErrorMessage = self::validateAddressAdditionForMaxLengthConstraintFromSetAddressAddition($addressAddition))) {
            throw new \InvalidArgumentException($addressAdditionMaxLengthErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($addressAddition) && count($addressAddition) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($addressAddition)), __LINE__);
        }
        $this->addressAddition = $addressAddition;
        return $this;
    }
    /**
     * Add item to addressAddition value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\NativeAddressType
     */
    public function addToAddressAddition($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The addressAddition property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (mb_strlen($item) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->addressAddition) && count($this->addressAddition) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->addressAddition)), __LINE__);
        }
        $this->addressAddition[] = $item;
        return $this;
    }
    /**
     * Get dispatchingInformation value
     * @return string|null
     */
    public function getDispatchingInformation()
    {
        return $this->dispatchingInformation;
    }
    /**
     * Set dispatchingInformation value
     * @param string $dispatchingInformation
     * @return \StructType\NativeAddressType
     */
    public function setDispatchingInformation($dispatchingInformation = null)
    {
        // validation for constraint: string
        if (!is_null($dispatchingInformation) && !is_string($dispatchingInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dispatchingInformation, true), gettype($dispatchingInformation)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($dispatchingInformation) && mb_strlen($dispatchingInformation) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($dispatchingInformation)), __LINE__);
        }
        $this->dispatchingInformation = $dispatchingInformation;
        return $this;
    }
    /**
     * Get zip value
     * @return string|null
     */
    public function getZip()
    {
        return $this->zip;
    }
    /**
     * Set zip value
     * @param string $zip
     * @return \StructType\NativeAddressType
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zip, true), gettype($zip)), __LINE__);
        }
        // validation for constraint: maxLength(17)
        if (!is_null($zip) && mb_strlen($zip) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 17', mb_strlen($zip)), __LINE__);
        }
        $this->zip = $zip;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\NativeAddressType
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($city) && mb_strlen($city) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get province value
     * @return string|null
     */
    public function getProvince()
    {
        return $this->province;
    }
    /**
     * Set province value
     * @param string $province
     * @return \StructType\NativeAddressType
     */
    public function setProvince($province = null)
    {
        // validation for constraint: string
        if (!is_null($province) && !is_string($province)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($province, true), gettype($province)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($province) && mb_strlen($province) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($province)), __LINE__);
        }
        $this->province = $province;
        return $this;
    }
    /**
     * Get Origin value
     * @return \StructType\CountryType|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param \StructType\CountryType $origin
     * @return \StructType\NativeAddressType
     */
    public function setOrigin(\StructType\CountryType $origin = null)
    {
        $this->Origin = $origin;
        return $this;
    }
}
