<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ManifestState StructType
 * Meta information extracted from the WSDL
 * - documentation: ShipmentNumber | The status of a doManifest operation.
 * @subpackage Structs
 */
class ManifestState extends AbstractStructBase
{
    /**
     * The shipmentNumber
     * Meta information extracted from the WSDL
     * - documentation: Can contain any DHL shipmentnumber. | Can contain any DHL shipmentnumber. For successful and unsuccessful operations, the requested ShipmentNumber to be deleted is returned. This is no matter if the operation could be performed or
     * not.
     * - base: xs:string
     * - maxLength: 39
     * - minOccurs: 0
     * - ref: cis:shipmentNumber
     * @var string
     */
    public $shipmentNumber;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Status of the request (value of zero means, the request was processed without error; value greater than zero indicates that an error occurred).
     * @var \StructType\Statusinformation
     */
    public $Status;
    /**
     * Constructor method for ManifestState
     * @uses ManifestState::setShipmentNumber()
     * @uses ManifestState::setStatus()
     * @param string $shipmentNumber
     * @param \StructType\Statusinformation $status
     */
    public function __construct($shipmentNumber = null, \StructType\Statusinformation $status = null)
    {
        $this
            ->setShipmentNumber($shipmentNumber)
            ->setStatus($status);
    }
    /**
     * Get shipmentNumber value
     * @return string|null
     */
    public function getShipmentNumber()
    {
        return $this->shipmentNumber;
    }
    /**
     * Set shipmentNumber value
     * @param string $shipmentNumber
     * @return \StructType\ManifestState
     */
    public function setShipmentNumber($shipmentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentNumber) && !is_string($shipmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentNumber, true), gettype($shipmentNumber)), __LINE__);
        }
        // validation for constraint: maxLength(39)
        if (!is_null($shipmentNumber) && mb_strlen($shipmentNumber) > 39) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 39', mb_strlen($shipmentNumber)), __LINE__);
        }
        $this->shipmentNumber = $shipmentNumber;
        return $this;
    }
    /**
     * Get Status value
     * @return \StructType\Statusinformation|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\Statusinformation $status
     * @return \StructType\ManifestState
     */
    public function setStatus(\StructType\Statusinformation $status = null)
    {
        $this->Status = $status;
        return $this;
    }
}
