<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LabelData StructType
 * Meta information extracted from the WSDL
 * - documentation: For successful and unsuccessful operations, the requested ShipmentNumber of the label to be retrieved is returned. This is no matter if it the operation could be performed or not. | The status of the getLabel operation and the url
 * for requesting the label (if available).
 * @subpackage Structs
 */
class LabelData extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Success status of processing retrieval of particular shipment label.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Statusinformation
     */
    public $Status;
    /**
     * The shipmentNumber
     * Meta information extracted from the WSDL
     * - documentation: Can contain any DHL shipmentnumber. | Can contain any DHL shipmentnumber. For successful and unsuccessful operations, the requested ShipmentNumber to be deleted is returned. This is no matter if the operation could be performed or
     * not.
     * - base: xs:string
     * - maxLength: 39
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: cis:shipmentNumber
     * @var string
     */
    public $shipmentNumber;
    /**
     * The labelUrl
     * Meta information extracted from the WSDL
     * - documentation: If label output format was requested as 'URL' via LabelResponseType, this element will be returned. It contains the URL to access the PDF label. This is default output format if not specified other by client in labelResponseType.
     * Depending on setting in customer profile all labels or just the shipmentlabel.
     * - choice: labelUrl | labelData
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - minOccurs: 0
     * @var string
     */
    public $labelUrl;
    /**
     * The labelData
     * Meta information extracted from the WSDL
     * - documentation: Label as base64 encoded pdf data, depending on setting in customer profile all labels or just the shipmentlabel.
     * - choice: labelUrl | labelData
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - minOccurs: 0
     * @var string
     */
    public $labelData;
    /**
     * The returnLabelUrl
     * Meta information extracted from the WSDL
     * - documentation: If label output format was requested as 'URL' via LabelResponseType, this element will be returned. It contains the URL to access the PDF label. This is default output format if not specified other by client in labelResponseType.
     * Depending on setting in customer profile all labels or just the returnshipmentlabel.
     * - choice: returnLabelUrl | returnLabelData
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - minOccurs: 0
     * @var string
     */
    public $returnLabelUrl;
    /**
     * The returnLabelData
     * Meta information extracted from the WSDL
     * - documentation: Label as base64 encoded pdf data, depending on setting in customer profile all labels or just the returnshipmentlabel.
     * - choice: returnLabelUrl | returnLabelData
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - minOccurs: 0
     * @var string
     */
    public $returnLabelData;
    /**
     * The exportLabelUrl
     * Meta information extracted from the WSDL
     * - documentation: If label output format was requested as 'URL' via LabelResponseType, this element will be returned. It contains the URL to access the PDF label. This is default output format if not specified other by client in labelResponseType.
     * Depending on setting in customer profile all labels or just the export documents.
     * - choice: exportLabelUrl | exportLabelData
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - minOccurs: 0
     * @var string
     */
    public $exportLabelUrl;
    /**
     * The exportLabelData
     * Meta information extracted from the WSDL
     * - documentation: Label as base64 encoded pdf data, depending on setting in customer profile all labels or just the export documents.
     * - choice: exportLabelUrl | exportLabelData
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - minOccurs: 0
     * @var string
     */
    public $exportLabelData;
    /**
     * The codLabelUrl
     * Meta information extracted from the WSDL
     * - documentation: If label output format was requested as 'URL' via LabelResponseType, this element will be returned. It contains the URL to access the PDF label. This is default output format if not specified other by client in labelResponseType.
     * Depending on setting in customer profile all labels or just the cod related documents.
     * - choice: codLabelUrl | codLabelData
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - minOccurs: 0
     * @var string
     */
    public $codLabelUrl;
    /**
     * The codLabelData
     * Meta information extracted from the WSDL
     * - documentation: Label as base64 encoded pdf data, depending on setting in customer profile all labels or just the cod related documents.
     * - choice: codLabelUrl | codLabelData
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - minOccurs: 0
     * @var string
     */
    public $codLabelData;
    /**
     * Constructor method for LabelData
     * @uses LabelData::setStatus()
     * @uses LabelData::setShipmentNumber()
     * @uses LabelData::setLabelUrl()
     * @uses LabelData::setLabelData()
     * @uses LabelData::setReturnLabelUrl()
     * @uses LabelData::setReturnLabelData()
     * @uses LabelData::setExportLabelUrl()
     * @uses LabelData::setExportLabelData()
     * @uses LabelData::setCodLabelUrl()
     * @uses LabelData::setCodLabelData()
     * @param \StructType\Statusinformation $status
     * @param string $shipmentNumber
     * @param string $labelUrl
     * @param string $labelData
     * @param string $returnLabelUrl
     * @param string $returnLabelData
     * @param string $exportLabelUrl
     * @param string $exportLabelData
     * @param string $codLabelUrl
     * @param string $codLabelData
     */
    public function __construct(\StructType\Statusinformation $status = null, $shipmentNumber = null, $labelUrl = null, $labelData = null, $returnLabelUrl = null, $returnLabelData = null, $exportLabelUrl = null, $exportLabelData = null, $codLabelUrl = null, $codLabelData = null)
    {
        $this
            ->setStatus($status)
            ->setShipmentNumber($shipmentNumber)
            ->setLabelUrl($labelUrl)
            ->setLabelData($labelData)
            ->setReturnLabelUrl($returnLabelUrl)
            ->setReturnLabelData($returnLabelData)
            ->setExportLabelUrl($exportLabelUrl)
            ->setExportLabelData($exportLabelData)
            ->setCodLabelUrl($codLabelUrl)
            ->setCodLabelData($codLabelData);
    }
    /**
     * Get Status value
     * @return \StructType\Statusinformation
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\Statusinformation $status
     * @return \StructType\LabelData
     */
    public function setStatus(\StructType\Statusinformation $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get shipmentNumber value
     * @return string|null
     */
    public function getShipmentNumber()
    {
        return $this->shipmentNumber;
    }
    /**
     * Set shipmentNumber value
     * @param string $shipmentNumber
     * @return \StructType\LabelData
     */
    public function setShipmentNumber($shipmentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentNumber) && !is_string($shipmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentNumber, true), gettype($shipmentNumber)), __LINE__);
        }
        // validation for constraint: maxLength(39)
        if (!is_null($shipmentNumber) && mb_strlen($shipmentNumber) > 39) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 39', mb_strlen($shipmentNumber)), __LINE__);
        }
        $this->shipmentNumber = $shipmentNumber;
        return $this;
    }
    /**
     * Get labelUrl value
     * @return string|null
     */
    public function getLabelUrl()
    {
        return isset($this->labelUrl) ? $this->labelUrl : null;
    }
    /**
     * This method is responsible for validating the value passed to the setLabelUrl method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLabelUrl method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateLabelUrlForChoiceConstraintsFromSetLabelUrl($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'labelData',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property labelUrl can\'t be set as the property %s is already set. Only one property must be set among these properties: labelUrl, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set labelUrl value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $labelUrl
     * @return \StructType\LabelData
     */
    public function setLabelUrl($labelUrl = null)
    {
        // validation for constraint: string
        if (!is_null($labelUrl) && !is_string($labelUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labelUrl, true), gettype($labelUrl)), __LINE__);
        }
        // validation for constraint: choice(labelUrl, labelData)
        if ('' !== ($labelUrlChoiceErrorMessage = self::validateLabelUrlForChoiceConstraintsFromSetLabelUrl($labelUrl))) {
            throw new \InvalidArgumentException($labelUrlChoiceErrorMessage, __LINE__);
        }
        if (is_null($labelUrl) || (is_array($labelUrl) && empty($labelUrl))) {
            unset($this->labelUrl);
        } else {
            $this->labelUrl = $labelUrl;
        }
        return $this;
    }
    /**
     * Get labelData value
     * @return string|null
     */
    public function getLabelData()
    {
        return isset($this->labelData) ? $this->labelData : null;
    }
    /**
     * This method is responsible for validating the value passed to the setLabelData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLabelData method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateLabelDataForChoiceConstraintsFromSetLabelData($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'labelUrl',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property labelData can\'t be set as the property %s is already set. Only one property must be set among these properties: labelData, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set labelData value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $labelData
     * @return \StructType\LabelData
     */
    public function setLabelData($labelData = null)
    {
        // validation for constraint: string
        if (!is_null($labelData) && !is_string($labelData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labelData, true), gettype($labelData)), __LINE__);
        }
        // validation for constraint: choice(labelUrl, labelData)
        if ('' !== ($labelDataChoiceErrorMessage = self::validateLabelDataForChoiceConstraintsFromSetLabelData($labelData))) {
            throw new \InvalidArgumentException($labelDataChoiceErrorMessage, __LINE__);
        }
        if (is_null($labelData) || (is_array($labelData) && empty($labelData))) {
            unset($this->labelData);
        } else {
            $this->labelData = $labelData;
        }
        return $this;
    }
    /**
     * Get returnLabelUrl value
     * @return string|null
     */
    public function getReturnLabelUrl()
    {
        return isset($this->returnLabelUrl) ? $this->returnLabelUrl : null;
    }
    /**
     * This method is responsible for validating the value passed to the setReturnLabelUrl method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReturnLabelUrl method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateReturnLabelUrlForChoiceConstraintsFromSetReturnLabelUrl($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'returnLabelData',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property returnLabelUrl can\'t be set as the property %s is already set. Only one property must be set among these properties: returnLabelUrl, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set returnLabelUrl value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $returnLabelUrl
     * @return \StructType\LabelData
     */
    public function setReturnLabelUrl($returnLabelUrl = null)
    {
        // validation for constraint: string
        if (!is_null($returnLabelUrl) && !is_string($returnLabelUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnLabelUrl, true), gettype($returnLabelUrl)), __LINE__);
        }
        // validation for constraint: choice(returnLabelUrl, returnLabelData)
        if ('' !== ($returnLabelUrlChoiceErrorMessage = self::validateReturnLabelUrlForChoiceConstraintsFromSetReturnLabelUrl($returnLabelUrl))) {
            throw new \InvalidArgumentException($returnLabelUrlChoiceErrorMessage, __LINE__);
        }
        if (is_null($returnLabelUrl) || (is_array($returnLabelUrl) && empty($returnLabelUrl))) {
            unset($this->returnLabelUrl);
        } else {
            $this->returnLabelUrl = $returnLabelUrl;
        }
        return $this;
    }
    /**
     * Get returnLabelData value
     * @return string|null
     */
    public function getReturnLabelData()
    {
        return isset($this->returnLabelData) ? $this->returnLabelData : null;
    }
    /**
     * This method is responsible for validating the value passed to the setReturnLabelData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReturnLabelData method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateReturnLabelDataForChoiceConstraintsFromSetReturnLabelData($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'returnLabelUrl',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property returnLabelData can\'t be set as the property %s is already set. Only one property must be set among these properties: returnLabelData, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set returnLabelData value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $returnLabelData
     * @return \StructType\LabelData
     */
    public function setReturnLabelData($returnLabelData = null)
    {
        // validation for constraint: string
        if (!is_null($returnLabelData) && !is_string($returnLabelData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnLabelData, true), gettype($returnLabelData)), __LINE__);
        }
        // validation for constraint: choice(returnLabelUrl, returnLabelData)
        if ('' !== ($returnLabelDataChoiceErrorMessage = self::validateReturnLabelDataForChoiceConstraintsFromSetReturnLabelData($returnLabelData))) {
            throw new \InvalidArgumentException($returnLabelDataChoiceErrorMessage, __LINE__);
        }
        if (is_null($returnLabelData) || (is_array($returnLabelData) && empty($returnLabelData))) {
            unset($this->returnLabelData);
        } else {
            $this->returnLabelData = $returnLabelData;
        }
        return $this;
    }
    /**
     * Get exportLabelUrl value
     * @return string|null
     */
    public function getExportLabelUrl()
    {
        return isset($this->exportLabelUrl) ? $this->exportLabelUrl : null;
    }
    /**
     * This method is responsible for validating the value passed to the setExportLabelUrl method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExportLabelUrl method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateExportLabelUrlForChoiceConstraintsFromSetExportLabelUrl($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'exportLabelData',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property exportLabelUrl can\'t be set as the property %s is already set. Only one property must be set among these properties: exportLabelUrl, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set exportLabelUrl value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $exportLabelUrl
     * @return \StructType\LabelData
     */
    public function setExportLabelUrl($exportLabelUrl = null)
    {
        // validation for constraint: string
        if (!is_null($exportLabelUrl) && !is_string($exportLabelUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exportLabelUrl, true), gettype($exportLabelUrl)), __LINE__);
        }
        // validation for constraint: choice(exportLabelUrl, exportLabelData)
        if ('' !== ($exportLabelUrlChoiceErrorMessage = self::validateExportLabelUrlForChoiceConstraintsFromSetExportLabelUrl($exportLabelUrl))) {
            throw new \InvalidArgumentException($exportLabelUrlChoiceErrorMessage, __LINE__);
        }
        if (is_null($exportLabelUrl) || (is_array($exportLabelUrl) && empty($exportLabelUrl))) {
            unset($this->exportLabelUrl);
        } else {
            $this->exportLabelUrl = $exportLabelUrl;
        }
        return $this;
    }
    /**
     * Get exportLabelData value
     * @return string|null
     */
    public function getExportLabelData()
    {
        return isset($this->exportLabelData) ? $this->exportLabelData : null;
    }
    /**
     * This method is responsible for validating the value passed to the setExportLabelData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExportLabelData method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateExportLabelDataForChoiceConstraintsFromSetExportLabelData($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'exportLabelUrl',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property exportLabelData can\'t be set as the property %s is already set. Only one property must be set among these properties: exportLabelData, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set exportLabelData value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $exportLabelData
     * @return \StructType\LabelData
     */
    public function setExportLabelData($exportLabelData = null)
    {
        // validation for constraint: string
        if (!is_null($exportLabelData) && !is_string($exportLabelData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exportLabelData, true), gettype($exportLabelData)), __LINE__);
        }
        // validation for constraint: choice(exportLabelUrl, exportLabelData)
        if ('' !== ($exportLabelDataChoiceErrorMessage = self::validateExportLabelDataForChoiceConstraintsFromSetExportLabelData($exportLabelData))) {
            throw new \InvalidArgumentException($exportLabelDataChoiceErrorMessage, __LINE__);
        }
        if (is_null($exportLabelData) || (is_array($exportLabelData) && empty($exportLabelData))) {
            unset($this->exportLabelData);
        } else {
            $this->exportLabelData = $exportLabelData;
        }
        return $this;
    }
    /**
     * Get codLabelUrl value
     * @return string|null
     */
    public function getCodLabelUrl()
    {
        return isset($this->codLabelUrl) ? $this->codLabelUrl : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCodLabelUrl method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCodLabelUrl method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCodLabelUrlForChoiceConstraintsFromSetCodLabelUrl($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'codLabelData',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property codLabelUrl can\'t be set as the property %s is already set. Only one property must be set among these properties: codLabelUrl, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set codLabelUrl value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $codLabelUrl
     * @return \StructType\LabelData
     */
    public function setCodLabelUrl($codLabelUrl = null)
    {
        // validation for constraint: string
        if (!is_null($codLabelUrl) && !is_string($codLabelUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codLabelUrl, true), gettype($codLabelUrl)), __LINE__);
        }
        // validation for constraint: choice(codLabelUrl, codLabelData)
        if ('' !== ($codLabelUrlChoiceErrorMessage = self::validateCodLabelUrlForChoiceConstraintsFromSetCodLabelUrl($codLabelUrl))) {
            throw new \InvalidArgumentException($codLabelUrlChoiceErrorMessage, __LINE__);
        }
        if (is_null($codLabelUrl) || (is_array($codLabelUrl) && empty($codLabelUrl))) {
            unset($this->codLabelUrl);
        } else {
            $this->codLabelUrl = $codLabelUrl;
        }
        return $this;
    }
    /**
     * Get codLabelData value
     * @return string|null
     */
    public function getCodLabelData()
    {
        return isset($this->codLabelData) ? $this->codLabelData : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCodLabelData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCodLabelData method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCodLabelDataForChoiceConstraintsFromSetCodLabelData($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'codLabelUrl',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property codLabelData can\'t be set as the property %s is already set. Only one property must be set among these properties: codLabelData, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set codLabelData value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $codLabelData
     * @return \StructType\LabelData
     */
    public function setCodLabelData($codLabelData = null)
    {
        // validation for constraint: string
        if (!is_null($codLabelData) && !is_string($codLabelData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codLabelData, true), gettype($codLabelData)), __LINE__);
        }
        // validation for constraint: choice(codLabelUrl, codLabelData)
        if ('' !== ($codLabelDataChoiceErrorMessage = self::validateCodLabelDataForChoiceConstraintsFromSetCodLabelData($codLabelData))) {
            throw new \InvalidArgumentException($codLabelDataChoiceErrorMessage, __LINE__);
        }
        if (is_null($codLabelData) || (is_array($codLabelData) && empty($codLabelData))) {
            unset($this->codLabelData);
        } else {
            $this->codLabelData = $codLabelData;
        }
        return $this;
    }
}
