<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetExportDocResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: The version of the webservice implementation. | The status of the operation and requested export document.
 * @subpackage Structs
 */
class GetExportDocResponse extends AbstractStructBase
{
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - ref: bcs:Version
     * @var \StructType\Version
     */
    public $Version;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Status of the request (value of zero means, the request was processed without error; value greater than zero indicates that an error occurred).
     * @var \StructType\Statusinformation
     */
    public $Status;
    /**
     * The ExportDocData
     * Meta information extracted from the WSDL
     * - documentation: Contains the result of the document processing: in case of no errors, a base64 encoded PDF is contained; also, the status of this particular document generation and the passed shipment number are returned.
     * - maxOccurs: 30
     * - minOccurs: 0
     * @var \StructType\ExportDocData[]
     */
    public $ExportDocData;
    /**
     * Constructor method for GetExportDocResponse
     * @uses GetExportDocResponse::setVersion()
     * @uses GetExportDocResponse::setStatus()
     * @uses GetExportDocResponse::setExportDocData()
     * @param \StructType\Version $version
     * @param \StructType\Statusinformation $status
     * @param \StructType\ExportDocData[] $exportDocData
     */
    public function __construct(\StructType\Version $version = null, \StructType\Statusinformation $status = null, array $exportDocData = array())
    {
        $this
            ->setVersion($version)
            ->setStatus($status)
            ->setExportDocData($exportDocData);
    }
    /**
     * Get Version value
     * @return \StructType\Version|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param \StructType\Version $version
     * @return \StructType\GetExportDocResponse
     */
    public function setVersion(\StructType\Version $version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Status value
     * @return \StructType\Statusinformation|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\Statusinformation $status
     * @return \StructType\GetExportDocResponse
     */
    public function setStatus(\StructType\Statusinformation $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ExportDocData value
     * @return \StructType\ExportDocData[]|null
     */
    public function getExportDocData()
    {
        return $this->ExportDocData;
    }
    /**
     * This method is responsible for validating the values passed to the setExportDocData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExportDocData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExportDocDataForArrayConstraintsFromSetExportDocData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getExportDocResponseExportDocDataItem) {
            // validation for constraint: itemType
            if (!$getExportDocResponseExportDocDataItem instanceof \StructType\ExportDocData) {
                $invalidValues[] = is_object($getExportDocResponseExportDocDataItem) ? get_class($getExportDocResponseExportDocDataItem) : sprintf('%s(%s)', gettype($getExportDocResponseExportDocDataItem), var_export($getExportDocResponseExportDocDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ExportDocData property can only contain items of type \StructType\ExportDocData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ExportDocData value
     * @throws \InvalidArgumentException
     * @param \StructType\ExportDocData[] $exportDocData
     * @return \StructType\GetExportDocResponse
     */
    public function setExportDocData(array $exportDocData = array())
    {
        // validation for constraint: array
        if ('' !== ($exportDocDataArrayErrorMessage = self::validateExportDocDataForArrayConstraintsFromSetExportDocData($exportDocData))) {
            throw new \InvalidArgumentException($exportDocDataArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($exportDocData) && count($exportDocData) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 30', count($exportDocData)), __LINE__);
        }
        $this->ExportDocData = $exportDocData;
        return $this;
    }
    /**
     * Add item to ExportDocData value
     * @throws \InvalidArgumentException
     * @param \StructType\ExportDocData $item
     * @return \StructType\GetExportDocResponse
     */
    public function addToExportDocData(\StructType\ExportDocData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExportDocData) {
            throw new \InvalidArgumentException(sprintf('The ExportDocData property can only contain items of type \StructType\ExportDocData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($this->ExportDocData) && count($this->ExportDocData) >= 30) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 30', count($this->ExportDocData)), __LINE__);
        }
        $this->ExportDocData[] = $item;
        return $this;
    }
}
