<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ErrorType StructType
 * Meta information extracted from the WSDL
 * - documentation: includes | Type of error
 * @subpackage Structs
 */
class ErrorType extends AbstractStructBase
{
    /**
     * The priority
     * Meta information extracted from the WSDL
     * - documentation: Priority (e.g. error, warnung, .....)
     * - minOccurs: 0
     * @var int
     */
    public $priority;
    /**
     * The code
     * Meta information extracted from the WSDL
     * - documentation: Code
     * @var int
     */
    public $code;
    /**
     * The dateTime
     * Meta information extracted from the WSDL
     * - documentation: Occurence
     * @var string
     */
    public $dateTime;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - documentation: Short description
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The descriptionLong
     * Meta information extracted from the WSDL
     * - documentation: Detailed description
     * - minOccurs: 0
     * @var string
     */
    public $descriptionLong;
    /**
     * The solution
     * Meta information extracted from the WSDL
     * - documentation: Suggested solution
     * - minOccurs: 0
     * @var string
     */
    public $solution;
    /**
     * The application
     * Meta information extracted from the WSDL
     * - documentation: Name of application
     * - minOccurs: 0
     * @var string
     */
    public $application;
    /**
     * The module
     * Meta information extracted from the WSDL
     * - documentation: Module name
     * - minOccurs: 0
     * @var string
     */
    public $module;
    /**
     * Constructor method for ErrorType
     * @uses ErrorType::setPriority()
     * @uses ErrorType::setCode()
     * @uses ErrorType::setDateTime()
     * @uses ErrorType::setDescription()
     * @uses ErrorType::setDescriptionLong()
     * @uses ErrorType::setSolution()
     * @uses ErrorType::setApplication()
     * @uses ErrorType::setModule()
     * @param int $priority
     * @param int $code
     * @param string $dateTime
     * @param string $description
     * @param string $descriptionLong
     * @param string $solution
     * @param string $application
     * @param string $module
     */
    public function __construct($priority = null, $code = null, $dateTime = null, $description = null, $descriptionLong = null, $solution = null, $application = null, $module = null)
    {
        $this
            ->setPriority($priority)
            ->setCode($code)
            ->setDateTime($dateTime)
            ->setDescription($description)
            ->setDescriptionLong($descriptionLong)
            ->setSolution($solution)
            ->setApplication($application)
            ->setModule($module);
    }
    /**
     * Get priority value
     * @return int|null
     */
    public function getPriority()
    {
        return $this->priority;
    }
    /**
     * Set priority value
     * @param int $priority
     * @return \StructType\ErrorType
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        $this->priority = $priority;
        return $this;
    }
    /**
     * Get code value
     * @return int|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param int $code
     * @return \StructType\ErrorType
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !(is_int($code) || ctype_digit($code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get dateTime value
     * @return string|null
     */
    public function getDateTime()
    {
        return $this->dateTime;
    }
    /**
     * Set dateTime value
     * @param string $dateTime
     * @return \StructType\ErrorType
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTime, true), gettype($dateTime)), __LINE__);
        }
        $this->dateTime = $dateTime;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\ErrorType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get descriptionLong value
     * @return string|null
     */
    public function getDescriptionLong()
    {
        return $this->descriptionLong;
    }
    /**
     * Set descriptionLong value
     * @param string $descriptionLong
     * @return \StructType\ErrorType
     */
    public function setDescriptionLong($descriptionLong = null)
    {
        // validation for constraint: string
        if (!is_null($descriptionLong) && !is_string($descriptionLong)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descriptionLong, true), gettype($descriptionLong)), __LINE__);
        }
        $this->descriptionLong = $descriptionLong;
        return $this;
    }
    /**
     * Get solution value
     * @return string|null
     */
    public function getSolution()
    {
        return $this->solution;
    }
    /**
     * Set solution value
     * @param string $solution
     * @return \StructType\ErrorType
     */
    public function setSolution($solution = null)
    {
        // validation for constraint: string
        if (!is_null($solution) && !is_string($solution)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($solution, true), gettype($solution)), __LINE__);
        }
        $this->solution = $solution;
        return $this;
    }
    /**
     * Get application value
     * @return string|null
     */
    public function getApplication()
    {
        return $this->application;
    }
    /**
     * Set application value
     * @param string $application
     * @return \StructType\ErrorType
     */
    public function setApplication($application = null)
    {
        // validation for constraint: string
        if (!is_null($application) && !is_string($application)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($application, true), gettype($application)), __LINE__);
        }
        $this->application = $application;
        return $this;
    }
    /**
     * Get module value
     * @return string|null
     */
    public function getModule()
    {
        return $this->module;
    }
    /**
     * Set module value
     * @param string $module
     * @return \StructType\ErrorType
     */
    public function setModule($module = null)
    {
        // validation for constraint: string
        if (!is_null($module) && !is_string($module)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($module, true), gettype($module)), __LINE__);
        }
        $this->module = $module;
        return $this;
    }
}
