<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Dimension StructType
 * Meta information extracted from the WSDL
 * - documentation: includes | Package dimensions (length, width, height)
 * @subpackage Structs
 */
class Dimension extends AbstractStructBase
{
    /**
     * The length
     * Meta information extracted from the WSDL
     * - documentation: length of package
     * @var int
     */
    public $length;
    /**
     * The width
     * Meta information extracted from the WSDL
     * - documentation: width of package
     * @var int
     */
    public $width;
    /**
     * The height
     * Meta information extracted from the WSDL
     * - documentation: height of package
     * @var int
     */
    public $height;
    /**
     * The unit
     * Meta information extracted from the WSDL
     * - default: mm
     * - minOccurs: 0
     * @var string
     */
    public $unit;
    /**
     * Constructor method for Dimension
     * @uses Dimension::setLength()
     * @uses Dimension::setWidth()
     * @uses Dimension::setHeight()
     * @uses Dimension::setUnit()
     * @param int $length
     * @param int $width
     * @param int $height
     * @param string $unit
     */
    public function __construct($length = null, $width = null, $height = null, $unit = 'mm')
    {
        $this
            ->setLength($length)
            ->setWidth($width)
            ->setHeight($height)
            ->setUnit($unit);
    }
    /**
     * Get length value
     * @return int|null
     */
    public function getLength()
    {
        return $this->length;
    }
    /**
     * Set length value
     * @param int $length
     * @return \StructType\Dimension
     */
    public function setLength($length = null)
    {
        // validation for constraint: int
        if (!is_null($length) && !(is_int($length) || ctype_digit($length))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($length, true), gettype($length)), __LINE__);
        }
        $this->length = $length;
        return $this;
    }
    /**
     * Get width value
     * @return int|null
     */
    public function getWidth()
    {
        return $this->width;
    }
    /**
     * Set width value
     * @param int $width
     * @return \StructType\Dimension
     */
    public function setWidth($width = null)
    {
        // validation for constraint: int
        if (!is_null($width) && !(is_int($width) || ctype_digit($width))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        $this->width = $width;
        return $this;
    }
    /**
     * Get height value
     * @return int|null
     */
    public function getHeight()
    {
        return $this->height;
    }
    /**
     * Set height value
     * @param int $height
     * @return \StructType\Dimension
     */
    public function setHeight($height = null)
    {
        // validation for constraint: int
        if (!is_null($height) && !(is_int($height) || ctype_digit($height))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        $this->height = $height;
        return $this;
    }
    /**
     * Get unit value
     * @return string|null
     */
    public function getUnit()
    {
        return $this->unit;
    }
    /**
     * Set unit value
     * @uses \EnumType\Unit::valueIsValid()
     * @uses \EnumType\Unit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $unit
     * @return \StructType\Dimension
     */
    public function setUnit($unit = 'mm')
    {
        // validation for constraint: enumeration
        if (!\EnumType\Unit::valueIsValid($unit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Unit', is_array($unit) ? implode(', ', $unit) : var_export($unit, true), implode(', ', \EnumType\Unit::getValidValues())), __LINE__);
        }
        $this->unit = $unit;
        return $this;
    }
}
