<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreationState StructType
 * Meta information extracted from the WSDL
 * - documentation: The operation's success status for every single ShipmentOrder will be returned by one CreationState element. It is identifiable via SequenceNumber.
 * @subpackage Structs
 */
class CreationState extends AbstractStructBase
{
    /**
     * The sequenceNumber
     * Meta information extracted from the WSDL
     * - documentation: Identifier for ShipmentOrder set by client application in CreateShipment request. The defined value is looped through and returned unchanged by the web service within the response of createShipment. The client can therefore assign
     * the status information of the response to the correct ShipmentOrder of the request. | A sequence number defined by the (soap-) client. The sequenceNumber is returned by the webservice within the result of the createShipment operation, so that the
     * client is able to assign the shipment information of the response to the shipment data of the request.
     * - base: xs:string
     * - maxLength: 50
     * @var string
     */
    public $sequenceNumber;
    /**
     * The shipmentNumber
     * Meta information extracted from the WSDL
     * - documentation: Can contain any DHL shipmentnumber. | Can contain any DHL shipmentnumber. For successful and unsuccessful operations, the requested ShipmentNumber to be deleted is returned. This is no matter if the operation could be performed or
     * not.
     * - base: xs:string
     * - maxLength: 39
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $shipmentNumber;
    /**
     * The returnShipmentNumber
     * Meta information extracted from the WSDL
     * - documentation: Can contain any DHL shipmentnumber. For successful and unsuccessful operations, the requested ShipmentNumber to be deleted is returned. This is no matter if the operation could be performed or not.
     * - base: xs:string
     * - maxLength: 39
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnShipmentNumber;
    /**
     * The LabelData
     * Meta information extracted from the WSDL
     * - documentation: For successful operations, a shipment number is created and returned. Depending on the invoked product.
     * @var \StructType\LabelData
     */
    public $LabelData;
    /**
     * Constructor method for CreationState
     * @uses CreationState::setSequenceNumber()
     * @uses CreationState::setShipmentNumber()
     * @uses CreationState::setReturnShipmentNumber()
     * @uses CreationState::setLabelData()
     * @param string $sequenceNumber
     * @param string $shipmentNumber
     * @param string $returnShipmentNumber
     * @param \StructType\LabelData $labelData
     */
    public function __construct($sequenceNumber = null, $shipmentNumber = null, $returnShipmentNumber = null, \StructType\LabelData $labelData = null)
    {
        $this
            ->setSequenceNumber($sequenceNumber)
            ->setShipmentNumber($shipmentNumber)
            ->setReturnShipmentNumber($returnShipmentNumber)
            ->setLabelData($labelData);
    }
    /**
     * Get sequenceNumber value
     * @return string|null
     */
    public function getSequenceNumber()
    {
        return $this->sequenceNumber;
    }
    /**
     * Set sequenceNumber value
     * @param string $sequenceNumber
     * @return \StructType\CreationState
     */
    public function setSequenceNumber($sequenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($sequenceNumber) && !is_string($sequenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sequenceNumber, true), gettype($sequenceNumber)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($sequenceNumber) && mb_strlen($sequenceNumber) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($sequenceNumber)), __LINE__);
        }
        $this->sequenceNumber = $sequenceNumber;
        return $this;
    }
    /**
     * Get shipmentNumber value
     * @return string|null
     */
    public function getShipmentNumber()
    {
        return $this->shipmentNumber;
    }
    /**
     * Set shipmentNumber value
     * @param string $shipmentNumber
     * @return \StructType\CreationState
     */
    public function setShipmentNumber($shipmentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentNumber) && !is_string($shipmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentNumber, true), gettype($shipmentNumber)), __LINE__);
        }
        // validation for constraint: maxLength(39)
        if (!is_null($shipmentNumber) && mb_strlen($shipmentNumber) > 39) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 39', mb_strlen($shipmentNumber)), __LINE__);
        }
        $this->shipmentNumber = $shipmentNumber;
        return $this;
    }
    /**
     * Get returnShipmentNumber value
     * @return string|null
     */
    public function getReturnShipmentNumber()
    {
        return $this->returnShipmentNumber;
    }
    /**
     * Set returnShipmentNumber value
     * @param string $returnShipmentNumber
     * @return \StructType\CreationState
     */
    public function setReturnShipmentNumber($returnShipmentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($returnShipmentNumber) && !is_string($returnShipmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnShipmentNumber, true), gettype($returnShipmentNumber)), __LINE__);
        }
        // validation for constraint: maxLength(39)
        if (!is_null($returnShipmentNumber) && mb_strlen($returnShipmentNumber) > 39) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 39', mb_strlen($returnShipmentNumber)), __LINE__);
        }
        $this->returnShipmentNumber = $returnShipmentNumber;
        return $this;
    }
    /**
     * Get LabelData value
     * @return \StructType\LabelData|null
     */
    public function getLabelData()
    {
        return $this->LabelData;
    }
    /**
     * Set LabelData value
     * @param \StructType\LabelData $labelData
     * @return \StructType\CreationState
     */
    public function setLabelData(\StructType\LabelData $labelData = null)
    {
        $this->LabelData = $labelData;
        return $this;
    }
}
