<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateShipmentOrderRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: The version of the webservice implementation for which the requesting client is developed. | The shipmentdata for creating a shipment.
 * @subpackage Structs
 */
class CreateShipmentOrderRequest extends AbstractStructBase
{
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - ref: bcs:Version
     * @var \StructType\Version
     */
    public $Version;
    /**
     * The ShipmentOrder
     * Meta information extracted from the WSDL
     * - documentation: ShipmentOrder is the highest parent element that contains all data with respect to one shipment order.
     * - maxOccurs: 30
     * @var \StructType\ShipmentOrderType[]
     */
    public $ShipmentOrder;
    /**
     * The labelResponseType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $labelResponseType;
    /**
     * The groupProfileName
     * Meta information extracted from the WSDL
     * - documentation: The group profile you select defines the billing numbers you can use for creating shipments. To define group profiles please visit our business costumer portal. The group profile defines the shipments you can get documents for. The
     * shipment needs to have an account/billing number allocated to the group profile. To define group profiles please visit our business costumer portal. | The group profile you select defines the billing numbers you can use for creating shipments. To
     * define group profiles please visit our business costumer portal.
     * - base: xs:string
     * - minOccurs: 0
     * @var string
     */
    public $groupProfileName;
    /**
     * The labelFormat
     * Meta information extracted from the WSDL
     * - documentation: In this optional section you can define the following label formats: A4:common label laser printing A4 plain paper; 910-300-700: common label laser printing 105 x 205 mm (910-300-700); 910-300-700-oz: common label laser printing 105
     * x 205 mm without additional barcode labels (910-300-700); 910-300-300: common label laser printing 105 x 148 mm (910-300-700); 910-300-300-oz: common label laser printing 105 x 148 mm without additional barcode labels (910-300-300); 910-300-710:
     * common label laser printing 105 x 208 mm (910-300-710); 910-300-600: common label thermal printing 103 x 199 mm (910-300-600, 910-300-610); 910-300-400: common label thermal printing 103 x 150 mm (910-300-400, 910-300-410); 100x70mm: 100 x 70 mm
     * label (only for Warenpost and Warenpost International);
     * - base: xs:string
     * - minOccurs: 0
     * @var string
     */
    public $labelFormat;
    /**
     * The labelFormatRetoure
     * Meta information extracted from the WSDL
     * - documentation: In this optional section you can define the following label formats: A4:common label laser printing A4 plain paper; 910-300-700: common label laser printing 105 x 205 mm (910-300-700); 910-300-700-oz: common label laser printing 105
     * x 205 mm without additional barcode labels (910-300-700); 910-300-300: common label laser printing 105 x 148 mm (910-300-700); 910-300-300-oz: common label laser printing 105 x 148 mm without additional barcode labels (910-300-300); 910-300-710:
     * common label laser printing 105 x 208 mm (910-300-710); 910-300-600: common label thermal printing 103 x 199 mm (910-300-600, 910-300-610); 910-300-400: common label thermal printing 103 x 150 mm (910-300-400, 910-300-410); 100x70mm: 100 x 70 mm
     * label (only for Warenpost and Warenpost International);
     * - base: xs:string
     * - minOccurs: 0
     * @var string
     */
    public $labelFormatRetoure;
    /**
     * The combinedPrinting
     * Meta information extracted from the WSDL
     * - documentation: To get a single PDF for shipping and return label select this option.
     * - base: xs:string
     * - minOccurs: 0
     * @var string
     */
    public $combinedPrinting;
    /**
     * Constructor method for CreateShipmentOrderRequest
     * @uses CreateShipmentOrderRequest::setVersion()
     * @uses CreateShipmentOrderRequest::setShipmentOrder()
     * @uses CreateShipmentOrderRequest::setLabelResponseType()
     * @uses CreateShipmentOrderRequest::setGroupProfileName()
     * @uses CreateShipmentOrderRequest::setLabelFormat()
     * @uses CreateShipmentOrderRequest::setLabelFormatRetoure()
     * @uses CreateShipmentOrderRequest::setCombinedPrinting()
     * @param \StructType\Version $version
     * @param \StructType\ShipmentOrderType[] $shipmentOrder
     * @param string $labelResponseType
     * @param string $groupProfileName
     * @param string $labelFormat
     * @param string $labelFormatRetoure
     * @param string $combinedPrinting
     */
    public function __construct(\StructType\Version $version = null, array $shipmentOrder = array(), $labelResponseType = null, $groupProfileName = null, $labelFormat = null, $labelFormatRetoure = null, $combinedPrinting = null)
    {
        $this
            ->setVersion($version)
            ->setShipmentOrder($shipmentOrder)
            ->setLabelResponseType($labelResponseType)
            ->setGroupProfileName($groupProfileName)
            ->setLabelFormat($labelFormat)
            ->setLabelFormatRetoure($labelFormatRetoure)
            ->setCombinedPrinting($combinedPrinting);
    }
    /**
     * Get Version value
     * @return \StructType\Version|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param \StructType\Version $version
     * @return \StructType\CreateShipmentOrderRequest
     */
    public function setVersion(\StructType\Version $version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get ShipmentOrder value
     * @return \StructType\ShipmentOrderType[]|null
     */
    public function getShipmentOrder()
    {
        return $this->ShipmentOrder;
    }
    /**
     * This method is responsible for validating the values passed to the setShipmentOrder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentOrder method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentOrderForArrayConstraintsFromSetShipmentOrder(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $createShipmentOrderRequestShipmentOrderItem) {
            // validation for constraint: itemType
            if (!$createShipmentOrderRequestShipmentOrderItem instanceof \StructType\ShipmentOrderType) {
                $invalidValues[] = is_object($createShipmentOrderRequestShipmentOrderItem) ? get_class($createShipmentOrderRequestShipmentOrderItem) : sprintf('%s(%s)', gettype($createShipmentOrderRequestShipmentOrderItem), var_export($createShipmentOrderRequestShipmentOrderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShipmentOrder property can only contain items of type \StructType\ShipmentOrderType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShipmentOrder value
     * @throws \InvalidArgumentException
     * @param \StructType\ShipmentOrderType[] $shipmentOrder
     * @return \StructType\CreateShipmentOrderRequest
     */
    public function setShipmentOrder(array $shipmentOrder = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentOrderArrayErrorMessage = self::validateShipmentOrderForArrayConstraintsFromSetShipmentOrder($shipmentOrder))) {
            throw new \InvalidArgumentException($shipmentOrderArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($shipmentOrder) && count($shipmentOrder) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 30', count($shipmentOrder)), __LINE__);
        }
        $this->ShipmentOrder = $shipmentOrder;
        return $this;
    }
    /**
     * Add item to ShipmentOrder value
     * @throws \InvalidArgumentException
     * @param \StructType\ShipmentOrderType $item
     * @return \StructType\CreateShipmentOrderRequest
     */
    public function addToShipmentOrder(\StructType\ShipmentOrderType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ShipmentOrderType) {
            throw new \InvalidArgumentException(sprintf('The ShipmentOrder property can only contain items of type \StructType\ShipmentOrderType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($this->ShipmentOrder) && count($this->ShipmentOrder) >= 30) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 30', count($this->ShipmentOrder)), __LINE__);
        }
        $this->ShipmentOrder[] = $item;
        return $this;
    }
    /**
     * Get labelResponseType value
     * @return string|null
     */
    public function getLabelResponseType()
    {
        return $this->labelResponseType;
    }
    /**
     * Set labelResponseType value
     * @uses \EnumType\LabelResponseType::valueIsValid()
     * @uses \EnumType\LabelResponseType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $labelResponseType
     * @return \StructType\CreateShipmentOrderRequest
     */
    public function setLabelResponseType($labelResponseType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LabelResponseType::valueIsValid($labelResponseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\LabelResponseType', is_array($labelResponseType) ? implode(', ', $labelResponseType) : var_export($labelResponseType, true), implode(', ', \EnumType\LabelResponseType::getValidValues())), __LINE__);
        }
        $this->labelResponseType = $labelResponseType;
        return $this;
    }
    /**
     * Get groupProfileName value
     * @return string|null
     */
    public function getGroupProfileName()
    {
        return $this->groupProfileName;
    }
    /**
     * Set groupProfileName value
     * @param string $groupProfileName
     * @return \StructType\CreateShipmentOrderRequest
     */
    public function setGroupProfileName($groupProfileName = null)
    {
        // validation for constraint: string
        if (!is_null($groupProfileName) && !is_string($groupProfileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupProfileName, true), gettype($groupProfileName)), __LINE__);
        }
        $this->groupProfileName = $groupProfileName;
        return $this;
    }
    /**
     * Get labelFormat value
     * @return string|null
     */
    public function getLabelFormat()
    {
        return $this->labelFormat;
    }
    /**
     * Set labelFormat value
     * @param string $labelFormat
     * @return \StructType\CreateShipmentOrderRequest
     */
    public function setLabelFormat($labelFormat = null)
    {
        // validation for constraint: string
        if (!is_null($labelFormat) && !is_string($labelFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labelFormat, true), gettype($labelFormat)), __LINE__);
        }
        $this->labelFormat = $labelFormat;
        return $this;
    }
    /**
     * Get labelFormatRetoure value
     * @return string|null
     */
    public function getLabelFormatRetoure()
    {
        return $this->labelFormatRetoure;
    }
    /**
     * Set labelFormatRetoure value
     * @param string $labelFormatRetoure
     * @return \StructType\CreateShipmentOrderRequest
     */
    public function setLabelFormatRetoure($labelFormatRetoure = null)
    {
        // validation for constraint: string
        if (!is_null($labelFormatRetoure) && !is_string($labelFormatRetoure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labelFormatRetoure, true), gettype($labelFormatRetoure)), __LINE__);
        }
        $this->labelFormatRetoure = $labelFormatRetoure;
        return $this;
    }
    /**
     * Get combinedPrinting value
     * @return string|null
     */
    public function getCombinedPrinting()
    {
        return $this->combinedPrinting;
    }
    /**
     * Set combinedPrinting value
     * @param string $combinedPrinting
     * @return \StructType\CreateShipmentOrderRequest
     */
    public function setCombinedPrinting($combinedPrinting = null)
    {
        // validation for constraint: string
        if (!is_null($combinedPrinting) && !is_string($combinedPrinting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($combinedPrinting, true), gettype($combinedPrinting)), __LINE__);
        }
        $this->combinedPrinting = $combinedPrinting;
        return $this;
    }
}
