<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Sets the Authentification SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\AuthentificationType $authentification
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentification(\StructType\AuthentificationType $authentification, $nameSpace = 'http://dhl.de/webservice/cisbase', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Authentification', $authentification, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named updateShipmentOrder
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentification
     * - SOAPHeaderNamespaces: http://dhl.de/webservice/cisbase
     * - SOAPHeaderTypes: \StructType\AuthentificationType
     * - SOAPHeaders: required
     * - documentation: Updates a shipment order. | The shipment data. | The status of the updateShipment operation and the identifier for the shipment. | Updates a shipment order. | The authentication data and the shipment data. | The status of the
     * operation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateShipmentOrderRequest $part1
     * @return \StructType\UpdateShipmentOrderResponse|bool
     */
    public function updateShipmentOrder(\StructType\UpdateShipmentOrderRequest $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->updateShipmentOrder($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UpdateShipmentOrderResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
