<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidationState StructType
 * Meta information extracted from the WSDL
 * - documentation: The operation's success status for every single ShipmentOrder will be returned by one CreationState element. It is identifiable via SequenceNumber.
 * @subpackage Structs
 */
class ValidationState extends AbstractStructBase
{
    /**
     * The sequenceNumber
     * Meta information extracted from the WSDL
     * - documentation: Identifier for ShipmentOrder set by client application in CreateShipment request. The defined value is looped through and returned unchanged by the web service within the response of createShipment. The client can therefore assign
     * the status information of the response to the correct ShipmentOrder of the request. | A sequence number defined by the (soap-) client. The sequenceNumber is returned by the webservice within the result of the createShipment operation, so that the
     * client is able to assign the shipment information of the response to the shipment data of the request.
     * - base: xs:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sequenceNumber;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Success status of processing a particular shipment.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Statusinformation
     */
    public $Status;
    /**
     * Constructor method for ValidationState
     * @uses ValidationState::setSequenceNumber()
     * @uses ValidationState::setStatus()
     * @param string $sequenceNumber
     * @param \StructType\Statusinformation $status
     */
    public function __construct($sequenceNumber = null, \StructType\Statusinformation $status = null)
    {
        $this
            ->setSequenceNumber($sequenceNumber)
            ->setStatus($status);
    }
    /**
     * Get sequenceNumber value
     * @return string
     */
    public function getSequenceNumber()
    {
        return $this->sequenceNumber;
    }
    /**
     * Set sequenceNumber value
     * @param string $sequenceNumber
     * @return \StructType\ValidationState
     */
    public function setSequenceNumber($sequenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($sequenceNumber) && !is_string($sequenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sequenceNumber, true), gettype($sequenceNumber)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($sequenceNumber) && mb_strlen($sequenceNumber) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($sequenceNumber)), __LINE__);
        }
        $this->sequenceNumber = $sequenceNumber;
        return $this;
    }
    /**
     * Get Status value
     * @return \StructType\Statusinformation
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\Statusinformation $status
     * @return \StructType\ValidationState
     */
    public function setStatus(\StructType\Statusinformation $status = null)
    {
        $this->Status = $status;
        return $this;
    }
}
