<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidateShipmentResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: The version of the webservice implementation. | The status of the operation and the shipment identifier (if available).
 * @subpackage Structs
 */
class ValidateShipmentResponse extends AbstractStructBase
{
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - ref: bcs:Version
     * @var \StructType\Version
     */
    public $Version;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Success status after processing the overall request.
     * @var \StructType\Statusinformation
     */
    public $Status;
    /**
     * The ValidationState
     * Meta information extracted from the WSDL
     * - documentation: The operation's success status for every single ShipmentOrder will be returned by one CreationState element. It is identifiable via SequenceNumber.
     * - maxOccurs: 30
     * - minOccurs: 0
     * @var \StructType\ValidationState[]
     */
    public $ValidationState;
    /**
     * Constructor method for ValidateShipmentResponse
     * @uses ValidateShipmentResponse::setVersion()
     * @uses ValidateShipmentResponse::setStatus()
     * @uses ValidateShipmentResponse::setValidationState()
     * @param \StructType\Version $version
     * @param \StructType\Statusinformation $status
     * @param \StructType\ValidationState[] $validationState
     */
    public function __construct(\StructType\Version $version = null, \StructType\Statusinformation $status = null, array $validationState = array())
    {
        $this
            ->setVersion($version)
            ->setStatus($status)
            ->setValidationState($validationState);
    }
    /**
     * Get Version value
     * @return \StructType\Version|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param \StructType\Version $version
     * @return \StructType\ValidateShipmentResponse
     */
    public function setVersion(\StructType\Version $version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Status value
     * @return \StructType\Statusinformation|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\Statusinformation $status
     * @return \StructType\ValidateShipmentResponse
     */
    public function setStatus(\StructType\Statusinformation $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ValidationState value
     * @return \StructType\ValidationState[]|null
     */
    public function getValidationState()
    {
        return $this->ValidationState;
    }
    /**
     * This method is responsible for validating the values passed to the setValidationState method
     * This method is willingly generated in order to preserve the one-line inline validation within the setValidationState method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateValidationStateForArrayConstraintsFromSetValidationState(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $validateShipmentResponseValidationStateItem) {
            // validation for constraint: itemType
            if (!$validateShipmentResponseValidationStateItem instanceof \StructType\ValidationState) {
                $invalidValues[] = is_object($validateShipmentResponseValidationStateItem) ? get_class($validateShipmentResponseValidationStateItem) : sprintf('%s(%s)', gettype($validateShipmentResponseValidationStateItem), var_export($validateShipmentResponseValidationStateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ValidationState property can only contain items of type \StructType\ValidationState, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ValidationState value
     * @throws \InvalidArgumentException
     * @param \StructType\ValidationState[] $validationState
     * @return \StructType\ValidateShipmentResponse
     */
    public function setValidationState(array $validationState = array())
    {
        // validation for constraint: array
        if ('' !== ($validationStateArrayErrorMessage = self::validateValidationStateForArrayConstraintsFromSetValidationState($validationState))) {
            throw new \InvalidArgumentException($validationStateArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($validationState) && count($validationState) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 30', count($validationState)), __LINE__);
        }
        $this->ValidationState = $validationState;
        return $this;
    }
    /**
     * Add item to ValidationState value
     * @throws \InvalidArgumentException
     * @param \StructType\ValidationState $item
     * @return \StructType\ValidateShipmentResponse
     */
    public function addToValidationState(\StructType\ValidationState $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ValidationState) {
            throw new \InvalidArgumentException(sprintf('The ValidationState property can only contain items of type \StructType\ValidationState, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($this->ValidationState) && count($this->ValidationState) >= 30) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 30', count($this->ValidationState)), __LINE__);
        }
        $this->ValidationState[] = $item;
        return $this;
    }
}
