<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidateShipmentOrderRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: The version of the webservice implementation for which the requesting client is developed. | The shipmentdata for validating a shipment.
 * @subpackage Structs
 */
class ValidateShipmentOrderRequest extends AbstractStructBase
{
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - ref: bcs:Version
     * @var \StructType\Version
     */
    public $Version;
    /**
     * The ShipmentOrder
     * Meta information extracted from the WSDL
     * - documentation: ShipmentOrder is the highest parent element that contains all data with respect to one shipment order.
     * - maxOccurs: 30
     * @var \StructType\ValidateShipmentOrderType[]
     */
    public $ShipmentOrder;
    /**
     * Constructor method for ValidateShipmentOrderRequest
     * @uses ValidateShipmentOrderRequest::setVersion()
     * @uses ValidateShipmentOrderRequest::setShipmentOrder()
     * @param \StructType\Version $version
     * @param \StructType\ValidateShipmentOrderType[] $shipmentOrder
     */
    public function __construct(\StructType\Version $version = null, array $shipmentOrder = array())
    {
        $this
            ->setVersion($version)
            ->setShipmentOrder($shipmentOrder);
    }
    /**
     * Get Version value
     * @return \StructType\Version|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param \StructType\Version $version
     * @return \StructType\ValidateShipmentOrderRequest
     */
    public function setVersion(\StructType\Version $version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get ShipmentOrder value
     * @return \StructType\ValidateShipmentOrderType[]|null
     */
    public function getShipmentOrder()
    {
        return $this->ShipmentOrder;
    }
    /**
     * This method is responsible for validating the values passed to the setShipmentOrder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentOrder method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentOrderForArrayConstraintsFromSetShipmentOrder(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $validateShipmentOrderRequestShipmentOrderItem) {
            // validation for constraint: itemType
            if (!$validateShipmentOrderRequestShipmentOrderItem instanceof \StructType\ValidateShipmentOrderType) {
                $invalidValues[] = is_object($validateShipmentOrderRequestShipmentOrderItem) ? get_class($validateShipmentOrderRequestShipmentOrderItem) : sprintf('%s(%s)', gettype($validateShipmentOrderRequestShipmentOrderItem), var_export($validateShipmentOrderRequestShipmentOrderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShipmentOrder property can only contain items of type \StructType\ValidateShipmentOrderType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShipmentOrder value
     * @throws \InvalidArgumentException
     * @param \StructType\ValidateShipmentOrderType[] $shipmentOrder
     * @return \StructType\ValidateShipmentOrderRequest
     */
    public function setShipmentOrder(array $shipmentOrder = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentOrderArrayErrorMessage = self::validateShipmentOrderForArrayConstraintsFromSetShipmentOrder($shipmentOrder))) {
            throw new \InvalidArgumentException($shipmentOrderArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($shipmentOrder) && count($shipmentOrder) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 30', count($shipmentOrder)), __LINE__);
        }
        $this->ShipmentOrder = $shipmentOrder;
        return $this;
    }
    /**
     * Add item to ShipmentOrder value
     * @throws \InvalidArgumentException
     * @param \StructType\ValidateShipmentOrderType $item
     * @return \StructType\ValidateShipmentOrderRequest
     */
    public function addToShipmentOrder(\StructType\ValidateShipmentOrderType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ValidateShipmentOrderType) {
            throw new \InvalidArgumentException(sprintf('The ShipmentOrder property can only contain items of type \StructType\ValidateShipmentOrderType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($this->ShipmentOrder) && count($this->ShipmentOrder) >= 30) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 30', count($this->ShipmentOrder)), __LINE__);
        }
        $this->ShipmentOrder[] = $item;
        return $this;
    }
}
