<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimeFrame StructType
 * Meta information extracted from the WSDL
 * - documentation: includes | Time Frame in which actions should affect
 * @subpackage Structs
 */
class TimeFrame extends AbstractStructBase
{
    /**
     * The from
     * Meta information extracted from the WSDL
     * - documentation: begin of timeframe
     * @var string
     */
    public $from;
    /**
     * The until
     * Meta information extracted from the WSDL
     * - documentation: end of timeframe
     * @var string
     */
    public $until;
    /**
     * Constructor method for TimeFrame
     * @uses TimeFrame::setFrom()
     * @uses TimeFrame::setUntil()
     * @param string $from
     * @param string $until
     */
    public function __construct($from = null, $until = null)
    {
        $this
            ->setFrom($from)
            ->setUntil($until);
    }
    /**
     * Get from value
     * @return string|null
     */
    public function getFrom()
    {
        return $this->from;
    }
    /**
     * Set from value
     * @param string $from
     * @return \StructType\TimeFrame
     */
    public function setFrom($from = null)
    {
        // validation for constraint: string
        if (!is_null($from) && !is_string($from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($from, true), gettype($from)), __LINE__);
        }
        $this->from = $from;
        return $this;
    }
    /**
     * Get until value
     * @return string|null
     */
    public function getUntil()
    {
        return $this->until;
    }
    /**
     * Set until value
     * @param string $until
     * @return \StructType\TimeFrame
     */
    public function setUntil($until = null)
    {
        // validation for constraint: string
        if (!is_null($until) && !is_string($until)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($until, true), gettype($until)), __LINE__);
        }
        $this->until = $until;
        return $this;
    }
}
