<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Statusinformation StructType
 * Meta information extracted from the WSDL
 * - documentation: The status information used in different situations.
 * @subpackage Structs
 */
class Statusinformation extends AbstractStructBase
{
    /**
     * The statusText
     * Meta information extracted from the WSDL
     * - documentation: Explanation of the statuscode. Explains what types of errors occurred.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $statusText;
    /**
     * The statusCode
     * Meta information extracted from the WSDL
     * - documentation: Overall status of the entire request: A value of zero means, the request was processed without error. A value greater than zero indicates that an error occurred. The detailed mapping and explanation of returned status codes is
     * contained in the list.
     * @var int
     */
    public $statusCode;
    /**
     * The statusMessage
     * Meta information extracted from the WSDL
     * - documentation: Detailed explanation of errors or warnings, p.e. “Invalid postal code”. This element is kept for compatibility reasons only. Please use “statusType” und “errorMassage” with their subelements instead.
     * - maxOccurs: 30
     * - minOccurs: 0
     * @var string[]
     */
    public $statusMessage;
    /**
     * The statusType
     * Meta information extracted from the WSDL
     * - documentation: Explains if an error or warning occurred
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $statusType;
    /**
     * The errorMessage
     * Meta information extracted from the WSDL
     * - documentation: Explains details of the error and where it occurred
     * - maxOccurs: 30
     * - minOccurs: 0
     * @var \StructType\StatusElement[]
     */
    public $errorMessage;
    /**
     * The warningMessage
     * Meta information extracted from the WSDL
     * - documentation: Explains details of the error and where it occurred
     * - maxOccurs: 30
     * - minOccurs: 0
     * @var \StructType\StatusElement[]
     */
    public $warningMessage;
    /**
     * Constructor method for Statusinformation
     * @uses Statusinformation::setStatusText()
     * @uses Statusinformation::setStatusCode()
     * @uses Statusinformation::setStatusMessage()
     * @uses Statusinformation::setStatusType()
     * @uses Statusinformation::setErrorMessage()
     * @uses Statusinformation::setWarningMessage()
     * @param string $statusText
     * @param int $statusCode
     * @param string[] $statusMessage
     * @param string $statusType
     * @param \StructType\StatusElement[] $errorMessage
     * @param \StructType\StatusElement[] $warningMessage
     */
    public function __construct($statusText = null, $statusCode = null, array $statusMessage = array(), $statusType = null, array $errorMessage = array(), array $warningMessage = array())
    {
        $this
            ->setStatusText($statusText)
            ->setStatusCode($statusCode)
            ->setStatusMessage($statusMessage)
            ->setStatusType($statusType)
            ->setErrorMessage($errorMessage)
            ->setWarningMessage($warningMessage);
    }
    /**
     * Get statusText value
     * @return string
     */
    public function getStatusText()
    {
        return $this->statusText;
    }
    /**
     * Set statusText value
     * @param string $statusText
     * @return \StructType\Statusinformation
     */
    public function setStatusText($statusText = null)
    {
        // validation for constraint: string
        if (!is_null($statusText) && !is_string($statusText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusText, true), gettype($statusText)), __LINE__);
        }
        $this->statusText = $statusText;
        return $this;
    }
    /**
     * Get statusCode value
     * @return int|null
     */
    public function getStatusCode()
    {
        return $this->statusCode;
    }
    /**
     * Set statusCode value
     * @param int $statusCode
     * @return \StructType\Statusinformation
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: int
        if (!is_null($statusCode) && !(is_int($statusCode) || ctype_digit($statusCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->statusCode = $statusCode;
        return $this;
    }
    /**
     * Get statusMessage value
     * @return string[]|null
     */
    public function getStatusMessage()
    {
        return $this->statusMessage;
    }
    /**
     * This method is responsible for validating the values passed to the setStatusMessage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStatusMessage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStatusMessageForArrayConstraintsFromSetStatusMessage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $statusinformationStatusMessageItem) {
            // validation for constraint: itemType
            if (!is_string($statusinformationStatusMessageItem)) {
                $invalidValues[] = is_object($statusinformationStatusMessageItem) ? get_class($statusinformationStatusMessageItem) : sprintf('%s(%s)', gettype($statusinformationStatusMessageItem), var_export($statusinformationStatusMessageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The statusMessage property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set statusMessage value
     * @throws \InvalidArgumentException
     * @param string[] $statusMessage
     * @return \StructType\Statusinformation
     */
    public function setStatusMessage(array $statusMessage = array())
    {
        // validation for constraint: array
        if ('' !== ($statusMessageArrayErrorMessage = self::validateStatusMessageForArrayConstraintsFromSetStatusMessage($statusMessage))) {
            throw new \InvalidArgumentException($statusMessageArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($statusMessage) && count($statusMessage) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 30', count($statusMessage)), __LINE__);
        }
        $this->statusMessage = $statusMessage;
        return $this;
    }
    /**
     * Add item to statusMessage value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Statusinformation
     */
    public function addToStatusMessage($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The statusMessage property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($this->statusMessage) && count($this->statusMessage) >= 30) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 30', count($this->statusMessage)), __LINE__);
        }
        $this->statusMessage[] = $item;
        return $this;
    }
    /**
     * Get statusType value
     * @return string|null
     */
    public function getStatusType()
    {
        return $this->statusType;
    }
    /**
     * Set statusType value
     * @param string $statusType
     * @return \StructType\Statusinformation
     */
    public function setStatusType($statusType = null)
    {
        // validation for constraint: string
        if (!is_null($statusType) && !is_string($statusType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusType, true), gettype($statusType)), __LINE__);
        }
        $this->statusType = $statusType;
        return $this;
    }
    /**
     * Get errorMessage value
     * @return \StructType\StatusElement[]|null
     */
    public function getErrorMessage()
    {
        return $this->errorMessage;
    }
    /**
     * This method is responsible for validating the values passed to the setErrorMessage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErrorMessage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateErrorMessageForArrayConstraintsFromSetErrorMessage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $statusinformationErrorMessageItem) {
            // validation for constraint: itemType
            if (!$statusinformationErrorMessageItem instanceof \StructType\StatusElement) {
                $invalidValues[] = is_object($statusinformationErrorMessageItem) ? get_class($statusinformationErrorMessageItem) : sprintf('%s(%s)', gettype($statusinformationErrorMessageItem), var_export($statusinformationErrorMessageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The errorMessage property can only contain items of type \StructType\StatusElement, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set errorMessage value
     * @throws \InvalidArgumentException
     * @param \StructType\StatusElement[] $errorMessage
     * @return \StructType\Statusinformation
     */
    public function setErrorMessage(array $errorMessage = array())
    {
        // validation for constraint: array
        if ('' !== ($errorMessageArrayErrorMessage = self::validateErrorMessageForArrayConstraintsFromSetErrorMessage($errorMessage))) {
            throw new \InvalidArgumentException($errorMessageArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($errorMessage) && count($errorMessage) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 30', count($errorMessage)), __LINE__);
        }
        $this->errorMessage = $errorMessage;
        return $this;
    }
    /**
     * Add item to errorMessage value
     * @throws \InvalidArgumentException
     * @param \StructType\StatusElement $item
     * @return \StructType\Statusinformation
     */
    public function addToErrorMessage(\StructType\StatusElement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StatusElement) {
            throw new \InvalidArgumentException(sprintf('The errorMessage property can only contain items of type \StructType\StatusElement, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($this->errorMessage) && count($this->errorMessage) >= 30) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 30', count($this->errorMessage)), __LINE__);
        }
        $this->errorMessage[] = $item;
        return $this;
    }
    /**
     * Get warningMessage value
     * @return \StructType\StatusElement[]|null
     */
    public function getWarningMessage()
    {
        return $this->warningMessage;
    }
    /**
     * This method is responsible for validating the values passed to the setWarningMessage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWarningMessage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWarningMessageForArrayConstraintsFromSetWarningMessage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $statusinformationWarningMessageItem) {
            // validation for constraint: itemType
            if (!$statusinformationWarningMessageItem instanceof \StructType\StatusElement) {
                $invalidValues[] = is_object($statusinformationWarningMessageItem) ? get_class($statusinformationWarningMessageItem) : sprintf('%s(%s)', gettype($statusinformationWarningMessageItem), var_export($statusinformationWarningMessageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The warningMessage property can only contain items of type \StructType\StatusElement, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set warningMessage value
     * @throws \InvalidArgumentException
     * @param \StructType\StatusElement[] $warningMessage
     * @return \StructType\Statusinformation
     */
    public function setWarningMessage(array $warningMessage = array())
    {
        // validation for constraint: array
        if ('' !== ($warningMessageArrayErrorMessage = self::validateWarningMessageForArrayConstraintsFromSetWarningMessage($warningMessage))) {
            throw new \InvalidArgumentException($warningMessageArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($warningMessage) && count($warningMessage) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 30', count($warningMessage)), __LINE__);
        }
        $this->warningMessage = $warningMessage;
        return $this;
    }
    /**
     * Add item to warningMessage value
     * @throws \InvalidArgumentException
     * @param \StructType\StatusElement $item
     * @return \StructType\Statusinformation
     */
    public function addToWarningMessage(\StructType\StatusElement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StatusElement) {
            throw new \InvalidArgumentException(sprintf('The warningMessage property can only contain items of type \StructType\StatusElement, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($this->warningMessage) && count($this->warningMessage) >= 30) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 30', count($this->warningMessage)), __LINE__);
        }
        $this->warningMessage[] = $item;
        return $this;
    }
}
