<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentNotificationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Notification type
 * @subpackage Structs
 */
class ShipmentNotificationType extends AbstractStructBase
{
    /**
     * The recipientEmailAddress
     * Meta information extracted from the WSDL
     * - documentation: Email address of the recipient. Mandatory if Notification is set.
     * - base: xs:string
     * - maxLength: 70
     * @var string
     */
    public $recipientEmailAddress;
    /**
     * The templateId
     * Meta information extracted from the WSDL
     * - documentation: You may choose between a standard DHL e-mail text (no ID needed) or configure an individual text within the section "Administration".
     * - base: xs:string
     * - maxLength: 35
     * - minOccurs: 0
     * @var string
     */
    public $templateId;
    /**
     * Constructor method for ShipmentNotificationType
     * @uses ShipmentNotificationType::setRecipientEmailAddress()
     * @uses ShipmentNotificationType::setTemplateId()
     * @param string $recipientEmailAddress
     * @param string $templateId
     */
    public function __construct($recipientEmailAddress = null, $templateId = null)
    {
        $this
            ->setRecipientEmailAddress($recipientEmailAddress)
            ->setTemplateId($templateId);
    }
    /**
     * Get recipientEmailAddress value
     * @return string|null
     */
    public function getRecipientEmailAddress()
    {
        return $this->recipientEmailAddress;
    }
    /**
     * Set recipientEmailAddress value
     * @param string $recipientEmailAddress
     * @return \StructType\ShipmentNotificationType
     */
    public function setRecipientEmailAddress($recipientEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($recipientEmailAddress) && !is_string($recipientEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recipientEmailAddress, true), gettype($recipientEmailAddress)), __LINE__);
        }
        // validation for constraint: maxLength(70)
        if (!is_null($recipientEmailAddress) && mb_strlen($recipientEmailAddress) > 70) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 70', mb_strlen($recipientEmailAddress)), __LINE__);
        }
        $this->recipientEmailAddress = $recipientEmailAddress;
        return $this;
    }
    /**
     * Get templateId value
     * @return string|null
     */
    public function getTemplateId()
    {
        return $this->templateId;
    }
    /**
     * Set templateId value
     * @param string $templateId
     * @return \StructType\ShipmentNotificationType
     */
    public function setTemplateId($templateId = null)
    {
        // validation for constraint: string
        if (!is_null($templateId) && !is_string($templateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($templateId, true), gettype($templateId)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($templateId) && mb_strlen($templateId) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($templateId)), __LINE__);
        }
        $this->templateId = $templateId;
        return $this;
    }
}
