<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceconfigurationCashOnDelivery StructType
 * @subpackage Structs
 */
class ServiceconfigurationCashOnDelivery extends AbstractStructBase
{
    /**
     * The active
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $active;
    /**
     * The codAmount
     * Meta information extracted from the WSDL
     * - base: xs:decimal
     * - maxInclusive: 9999999999
     * - minInclusive: 0.0
     * - use: required
     * @var float
     */
    public $codAmount;
    /**
     * Constructor method for ServiceconfigurationCashOnDelivery
     * @uses ServiceconfigurationCashOnDelivery::setActive()
     * @uses ServiceconfigurationCashOnDelivery::setCodAmount()
     * @param string $active
     * @param float $codAmount
     */
    public function __construct($active = null, $codAmount = null)
    {
        $this
            ->setActive($active)
            ->setCodAmount($codAmount);
    }
    /**
     * Get active value
     * @return string
     */
    public function getActive()
    {
        return $this->active;
    }
    /**
     * Set active value
     * @param string $active
     * @return \StructType\ServiceconfigurationCashOnDelivery
     */
    public function setActive($active = null)
    {
        // validation for constraint: string
        if (!is_null($active) && !is_string($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->active = $active;
        return $this;
    }
    /**
     * Get codAmount value
     * @return float
     */
    public function getCodAmount()
    {
        return $this->codAmount;
    }
    /**
     * Set codAmount value
     * @param float $codAmount
     * @return \StructType\ServiceconfigurationCashOnDelivery
     */
    public function setCodAmount($codAmount = null)
    {
        // validation for constraint: float
        if (!is_null($codAmount) && !(is_float($codAmount) || is_numeric($codAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($codAmount, true), gettype($codAmount)), __LINE__);
        }
        // validation for constraint: maxInclusive(9999999999)
        if (!is_null($codAmount) && $codAmount > 9999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999999', var_export($codAmount, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.0)
        if (!is_null($codAmount) && $codAmount < 0.0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.0', var_export($codAmount, true)), __LINE__);
        }
        $this->codAmount = $codAmount;
        return $this;
    }
}
