<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReceiverTypeType StructType
 * Meta information extracted from the WSDL
 * - documentation: The receiver data.
 * @subpackage Structs
 */
class ReceiverTypeType extends AbstractStructBase
{
    /**
     * The name1
     * Meta information extracted from the WSDL
     * - documentation: Name of receiver (first part)
     * - base: xs:string
     * - maxLength: 35
     * - ref: cis:name1
     * @var string
     */
    public $name1;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - documentation: The address data of the receiver.
     * - choice: Address | Packstation | Postfiliale
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\ReceiverNativeAddressType
     */
    public $Address;
    /**
     * The Packstation
     * Meta information extracted from the WSDL
     * - documentation: The address of the receiver is a german Packstation.
     * - choice: Address | Packstation | Postfiliale
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\PackStationType
     */
    public $Packstation;
    /**
     * The Postfiliale
     * Meta information extracted from the WSDL
     * - documentation: The address of the receiver is a german Postfiliale.
     * - choice: Address | Packstation | Postfiliale
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\PostfilialeTypeNoCountry
     */
    public $Postfiliale;
    /**
     * The Communication
     * Meta information extracted from the WSDL
     * - documentation: Information about communication.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CommunicationType
     */
    public $Communication;
    /**
     * Constructor method for ReceiverTypeType
     * @uses ReceiverTypeType::setName1()
     * @uses ReceiverTypeType::setAddress()
     * @uses ReceiverTypeType::setPackstation()
     * @uses ReceiverTypeType::setPostfiliale()
     * @uses ReceiverTypeType::setCommunication()
     * @param string $name1
     * @param \StructType\ReceiverNativeAddressType $address
     * @param \StructType\PackStationType $packstation
     * @param \StructType\PostfilialeTypeNoCountry $postfiliale
     * @param \StructType\CommunicationType $communication
     */
    public function __construct($name1 = null, \StructType\ReceiverNativeAddressType $address = null, \StructType\PackStationType $packstation = null, \StructType\PostfilialeTypeNoCountry $postfiliale = null, \StructType\CommunicationType $communication = null)
    {
        $this
            ->setName1($name1)
            ->setAddress($address)
            ->setPackstation($packstation)
            ->setPostfiliale($postfiliale)
            ->setCommunication($communication);
    }
    /**
     * Get name1 value
     * @return string|null
     */
    public function getName1()
    {
        return $this->name1;
    }
    /**
     * Set name1 value
     * @param string $name1
     * @return \StructType\ReceiverTypeType
     */
    public function setName1($name1 = null)
    {
        // validation for constraint: string
        if (!is_null($name1) && !is_string($name1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name1, true), gettype($name1)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($name1) && mb_strlen($name1) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($name1)), __LINE__);
        }
        $this->name1 = $name1;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\ReceiverNativeAddressType|null
     */
    public function getAddress()
    {
        return isset($this->Address) ? $this->Address : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddress method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAddressForChoiceConstraintsFromSetAddress($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Packstation',
            'Postfiliale',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Address can\'t be set as the property %s is already set. Only one property must be set among these properties: Address, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Address value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ReceiverNativeAddressType $address
     * @return \StructType\ReceiverTypeType
     */
    public function setAddress(\StructType\ReceiverNativeAddressType $address = null)
    {
        // validation for constraint: choice(Address, Packstation, Postfiliale)
        if ('' !== ($addressChoiceErrorMessage = self::validateAddressForChoiceConstraintsFromSetAddress($address))) {
            throw new \InvalidArgumentException($addressChoiceErrorMessage, __LINE__);
        }
        if (is_null($address) || (is_array($address) && empty($address))) {
            unset($this->Address);
        } else {
            $this->Address = $address;
        }
        return $this;
    }
    /**
     * Get Packstation value
     * @return \StructType\PackStationType|null
     */
    public function getPackstation()
    {
        return isset($this->Packstation) ? $this->Packstation : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPackstation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackstation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePackstationForChoiceConstraintsFromSetPackstation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Address',
            'Postfiliale',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Packstation can\'t be set as the property %s is already set. Only one property must be set among these properties: Packstation, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Packstation value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PackStationType $packstation
     * @return \StructType\ReceiverTypeType
     */
    public function setPackstation(\StructType\PackStationType $packstation = null)
    {
        // validation for constraint: choice(Address, Packstation, Postfiliale)
        if ('' !== ($packstationChoiceErrorMessage = self::validatePackstationForChoiceConstraintsFromSetPackstation($packstation))) {
            throw new \InvalidArgumentException($packstationChoiceErrorMessage, __LINE__);
        }
        if (is_null($packstation) || (is_array($packstation) && empty($packstation))) {
            unset($this->Packstation);
        } else {
            $this->Packstation = $packstation;
        }
        return $this;
    }
    /**
     * Get Postfiliale value
     * @return \StructType\PostfilialeTypeNoCountry|null
     */
    public function getPostfiliale()
    {
        return isset($this->Postfiliale) ? $this->Postfiliale : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPostfiliale method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPostfiliale method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePostfilialeForChoiceConstraintsFromSetPostfiliale($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Address',
            'Packstation',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Postfiliale can\'t be set as the property %s is already set. Only one property must be set among these properties: Postfiliale, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Postfiliale value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PostfilialeTypeNoCountry $postfiliale
     * @return \StructType\ReceiverTypeType
     */
    public function setPostfiliale(\StructType\PostfilialeTypeNoCountry $postfiliale = null)
    {
        // validation for constraint: choice(Address, Packstation, Postfiliale)
        if ('' !== ($postfilialeChoiceErrorMessage = self::validatePostfilialeForChoiceConstraintsFromSetPostfiliale($postfiliale))) {
            throw new \InvalidArgumentException($postfilialeChoiceErrorMessage, __LINE__);
        }
        if (is_null($postfiliale) || (is_array($postfiliale) && empty($postfiliale))) {
            unset($this->Postfiliale);
        } else {
            $this->Postfiliale = $postfiliale;
        }
        return $this;
    }
    /**
     * Get Communication value
     * @return \StructType\CommunicationType|null
     */
    public function getCommunication()
    {
        return $this->Communication;
    }
    /**
     * Set Communication value
     * @param \StructType\CommunicationType $communication
     * @return \StructType\ReceiverTypeType
     */
    public function setCommunication(\StructType\CommunicationType $communication = null)
    {
        $this->Communication = $communication;
        return $this;
    }
}
