<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PostfilialeTypeNoCountry StructType
 * Meta information extracted from the WSDL
 * - documentation: includes | Type of Postfiliale
 * @subpackage Structs
 */
class PostfilialeTypeNoCountry extends AbstractStructBase
{
    /**
     * The postfilialNumber
     * Meta information extracted from the WSDL
     * - documentation: Number of the postfiliale
     * - base: xs:string
     * - maxLength: 3
     * - minLength: 3
     * @var string
     */
    public $postfilialNumber;
    /**
     * The postNumber
     * Meta information extracted from the WSDL
     * - documentation: Post Nummer of the receiver, if not set receiver e-mail and/or mobilephone number needs to be set. When sending to a packstation with "DHL Paket" (V01PAK), the postnumber must always be entered. | Post Nummer of the receiver | Post
     * Nummer of the receiver or receiver e-mail-adress.
     * - base: xs:string
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $postNumber;
    /**
     * The zip
     * Meta information extracted from the WSDL
     * - documentation: Type of zip code
     * - base: xs:string
     * - maxLength: 17
     * - ref: cis:zip
     * @var string
     */
    public $zip;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - documentation: City name.
     * - base: xs:string
     * - maxLength: 50
     * - ref: cis:city
     * @var string
     */
    public $city;
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - documentation: Country.
     * - minOccurs: 0
     * @var \StructType\CountryType
     */
    public $Origin;
    /**
     * Constructor method for PostfilialeTypeNoCountry
     * @uses PostfilialeTypeNoCountry::setPostfilialNumber()
     * @uses PostfilialeTypeNoCountry::setPostNumber()
     * @uses PostfilialeTypeNoCountry::setZip()
     * @uses PostfilialeTypeNoCountry::setCity()
     * @uses PostfilialeTypeNoCountry::setOrigin()
     * @param string $postfilialNumber
     * @param string $postNumber
     * @param string $zip
     * @param string $city
     * @param \StructType\CountryType $origin
     */
    public function __construct($postfilialNumber = null, $postNumber = null, $zip = null, $city = null, \StructType\CountryType $origin = null)
    {
        $this
            ->setPostfilialNumber($postfilialNumber)
            ->setPostNumber($postNumber)
            ->setZip($zip)
            ->setCity($city)
            ->setOrigin($origin);
    }
    /**
     * Get postfilialNumber value
     * @return string|null
     */
    public function getPostfilialNumber()
    {
        return $this->postfilialNumber;
    }
    /**
     * Set postfilialNumber value
     * @param string $postfilialNumber
     * @return \StructType\PostfilialeTypeNoCountry
     */
    public function setPostfilialNumber($postfilialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($postfilialNumber) && !is_string($postfilialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postfilialNumber, true), gettype($postfilialNumber)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($postfilialNumber) && mb_strlen($postfilialNumber) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($postfilialNumber)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($postfilialNumber) && mb_strlen($postfilialNumber) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($postfilialNumber)), __LINE__);
        }
        $this->postfilialNumber = $postfilialNumber;
        return $this;
    }
    /**
     * Get postNumber value
     * @return string|null
     */
    public function getPostNumber()
    {
        return $this->postNumber;
    }
    /**
     * Set postNumber value
     * @param string $postNumber
     * @return \StructType\PostfilialeTypeNoCountry
     */
    public function setPostNumber($postNumber = null)
    {
        // validation for constraint: string
        if (!is_null($postNumber) && !is_string($postNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postNumber, true), gettype($postNumber)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($postNumber) && mb_strlen($postNumber) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($postNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($postNumber) && mb_strlen($postNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($postNumber)), __LINE__);
        }
        $this->postNumber = $postNumber;
        return $this;
    }
    /**
     * Get zip value
     * @return string|null
     */
    public function getZip()
    {
        return $this->zip;
    }
    /**
     * Set zip value
     * @param string $zip
     * @return \StructType\PostfilialeTypeNoCountry
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zip, true), gettype($zip)), __LINE__);
        }
        // validation for constraint: maxLength(17)
        if (!is_null($zip) && mb_strlen($zip) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 17', mb_strlen($zip)), __LINE__);
        }
        $this->zip = $zip;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\PostfilialeTypeNoCountry
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($city) && mb_strlen($city) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get Origin value
     * @return \StructType\CountryType|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param \StructType\CountryType $origin
     * @return \StructType\PostfilialeTypeNoCountry
     */
    public function setOrigin(\StructType\CountryType $origin = null)
    {
        $this->Origin = $origin;
        return $this;
    }
}
