<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PieceInformation StructType
 * Meta information extracted from the WSDL
 * - documentation: Information about each piece (e.g. the generated licence plate). For every piece, a PieceInformation container holds the license plate number.
 * @subpackage Structs
 */
class PieceInformation extends AbstractStructBase
{
    /**
     * The PieceNumber
     * Meta information extracted from the WSDL
     * - documentation: For every piece a piece number is created that is of one of the following types (mostly licensePlate).
     * - minOccurs: 0
     * @var \StructType\ShipmentNumberType
     */
    public $PieceNumber;
    /**
     * Constructor method for PieceInformation
     * @uses PieceInformation::setPieceNumber()
     * @param \StructType\ShipmentNumberType $pieceNumber
     */
    public function __construct(\StructType\ShipmentNumberType $pieceNumber = null)
    {
        $this
            ->setPieceNumber($pieceNumber);
    }
    /**
     * Get PieceNumber value
     * @return \StructType\ShipmentNumberType|null
     */
    public function getPieceNumber()
    {
        return $this->PieceNumber;
    }
    /**
     * Set PieceNumber value
     * @param \StructType\ShipmentNumberType $pieceNumber
     * @return \StructType\PieceInformation
     */
    public function setPieceNumber(\StructType\ShipmentNumberType $pieceNumber = null)
    {
        $this->PieceNumber = $pieceNumber;
        return $this;
    }
}
