<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PickupDetailsType StructType
 * Meta information extracted from the WSDL
 * - documentation: The details of a pickup order.
 * @subpackage Structs
 */
class PickupDetailsType extends AbstractStructBase
{
    /**
     * The PickupDate
     * Meta information extracted from the WSDL
     * - documentation: Pickup date in format yyyy-mm-dd. Mandatory if pickup is booked along with shipment order. | Pickup date in format yyyy-mm-dd.
     * - base: xs:string
     * - maxLength: 10
     * - minLength: 10
     * @var string
     */
    public $PickupDate;
    /**
     * The ReadyByTime
     * Meta information extracted from the WSDL
     * - documentation: Earliest time for pickup. Format is hh:mm.
     * - base: xs:string
     * - maxLength: 5
     * - minLength: 5
     * @var string
     */
    public $ReadyByTime;
    /**
     * The ClosingTime
     * Meta information extracted from the WSDL
     * - documentation: Lates time for pickup. Format is hh:mm.
     * - base: xs:string
     * - maxLength: 5
     * - minLength: 5
     * @var string
     */
    public $ClosingTime;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - documentation: Remarks to be considered when pickup is done.
     * - minOccurs: 0
     * @var string
     */
    public $Remark;
    /**
     * The PickupLocation
     * Meta information extracted from the WSDL
     * - documentation: Area to further detail pickup location beyond address.
     * @var string
     */
    public $PickupLocation;
    /**
     * Constructor method for PickupDetailsType
     * @uses PickupDetailsType::setPickupDate()
     * @uses PickupDetailsType::setReadyByTime()
     * @uses PickupDetailsType::setClosingTime()
     * @uses PickupDetailsType::setRemark()
     * @uses PickupDetailsType::setPickupLocation()
     * @param string $pickupDate
     * @param string $readyByTime
     * @param string $closingTime
     * @param string $remark
     * @param string $pickupLocation
     */
    public function __construct($pickupDate = null, $readyByTime = null, $closingTime = null, $remark = null, $pickupLocation = null)
    {
        $this
            ->setPickupDate($pickupDate)
            ->setReadyByTime($readyByTime)
            ->setClosingTime($closingTime)
            ->setRemark($remark)
            ->setPickupLocation($pickupLocation);
    }
    /**
     * Get PickupDate value
     * @return string|null
     */
    public function getPickupDate()
    {
        return $this->PickupDate;
    }
    /**
     * Set PickupDate value
     * @param string $pickupDate
     * @return \StructType\PickupDetailsType
     */
    public function setPickupDate($pickupDate = null)
    {
        // validation for constraint: string
        if (!is_null($pickupDate) && !is_string($pickupDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupDate, true), gettype($pickupDate)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($pickupDate) && mb_strlen($pickupDate) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($pickupDate)), __LINE__);
        }
        // validation for constraint: minLength(10)
        if (!is_null($pickupDate) && mb_strlen($pickupDate) < 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 10', mb_strlen($pickupDate)), __LINE__);
        }
        $this->PickupDate = $pickupDate;
        return $this;
    }
    /**
     * Get ReadyByTime value
     * @return string|null
     */
    public function getReadyByTime()
    {
        return $this->ReadyByTime;
    }
    /**
     * Set ReadyByTime value
     * @param string $readyByTime
     * @return \StructType\PickupDetailsType
     */
    public function setReadyByTime($readyByTime = null)
    {
        // validation for constraint: string
        if (!is_null($readyByTime) && !is_string($readyByTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($readyByTime, true), gettype($readyByTime)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($readyByTime) && mb_strlen($readyByTime) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($readyByTime)), __LINE__);
        }
        // validation for constraint: minLength(5)
        if (!is_null($readyByTime) && mb_strlen($readyByTime) < 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 5', mb_strlen($readyByTime)), __LINE__);
        }
        $this->ReadyByTime = $readyByTime;
        return $this;
    }
    /**
     * Get ClosingTime value
     * @return string|null
     */
    public function getClosingTime()
    {
        return $this->ClosingTime;
    }
    /**
     * Set ClosingTime value
     * @param string $closingTime
     * @return \StructType\PickupDetailsType
     */
    public function setClosingTime($closingTime = null)
    {
        // validation for constraint: string
        if (!is_null($closingTime) && !is_string($closingTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($closingTime, true), gettype($closingTime)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($closingTime) && mb_strlen($closingTime) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($closingTime)), __LINE__);
        }
        // validation for constraint: minLength(5)
        if (!is_null($closingTime) && mb_strlen($closingTime) < 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 5', mb_strlen($closingTime)), __LINE__);
        }
        $this->ClosingTime = $closingTime;
        return $this;
    }
    /**
     * Get Remark value
     * @return string|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * Set Remark value
     * @param string $remark
     * @return \StructType\PickupDetailsType
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Get PickupLocation value
     * @return string|null
     */
    public function getPickupLocation()
    {
        return $this->PickupLocation;
    }
    /**
     * Set PickupLocation value
     * @param string $pickupLocation
     * @return \StructType\PickupDetailsType
     */
    public function setPickupLocation($pickupLocation = null)
    {
        // validation for constraint: string
        if (!is_null($pickupLocation) && !is_string($pickupLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupLocation, true), gettype($pickupLocation)), __LINE__);
        }
        $this->PickupLocation = $pickupLocation;
        return $this;
    }
}
